/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.util.Map;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.ListModel;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.gui.ClientListCellRenderer;
import org.astrogrid.samp.gui.GuiClientSet;
import org.astrogrid.samp.gui.HubView;
import org.astrogrid.samp.hub.BasicHubService;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubServiceException;

public class GuiHubService
extends BasicHubService {
    private GuiClientSet clientSet_;

    public GuiHubService(Random random) {
        super(random);
    }

    public void start() {
        super.start();
        this.clientSet_ = (GuiClientSet)this.getClientSet();
    }

    protected ClientSet createClientSet() {
        return new GuiClientSet(this.getIdComparator());
    }

    public JComponent createHubPanel() {
        HubView hubView = new HubView();
        hubView.setClientListModel(this.getClientListModel());
        hubView.getClientList().setCellRenderer(new ClientListCellRenderer());
        return hubView;
    }

    public JFrame createHubWindow() {
        JFrame frame = new JFrame("SAMP Hub");
        frame.getContentPane().add(this.createHubPanel());
        frame.setIconImage(new ImageIcon(Client.class.getResource("images/hub.png")).getImage());
        frame.pack();
        return frame;
    }

    public void declareMetadata(Object id, Map meta) throws HubServiceException {
        super.declareMetadata(id, meta);
        this.clientSet_.scheduleClientChanged((String)id);
    }

    public void declareSubscriptions(Object id, Map subscriptions) throws HubServiceException {
        super.declareSubscriptions(id, subscriptions);
        this.clientSet_.scheduleClientChanged((String)id);
    }

    public ListModel getClientListModel() {
        return this.clientSet_;
    }
}

