/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.gui.Transmission;

public class TransmissionListIcon
implements Icon {
    private final ListModel rxModel_;
    private final ListModel txModel_;
    private final int size_;
    private final int transIconWidth_;
    private final Icon targetIcon_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransmissionListIcon(ListModel rxModel, ListModel txModel, int size) {
        this.rxModel_ = rxModel;
        this.txModel_ = txModel;
        this.size_ = size;
        this.transIconWidth_ = (int)Math.floor((double)this.size_ * 0.866);
        boolean hasTx = this.txModel_ != null;
        boolean hasRx = this.rxModel_ != null;
        this.targetIcon_ = new Icon(){

            public int getIconWidth() {
                return TransmissionListIcon.this.size_;
            }

            public int getIconHeight() {
                return TransmissionListIcon.this.size_;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.drawOval(x + 1, y + 1, TransmissionListIcon.this.size_ - 2, TransmissionListIcon.this.size_ - 2);
            }
        };
    }

    public Transmission getTransmissionAt(Point point) {
        int x = point.x;
        int y = point.y;
        if (x < 0 || x > this.getIconWidth() || y < 0 || y > this.getIconHeight()) {
            return null;
        }
        int x0 = 0;
        int rxWidth = this.rxModel_.getSize() * this.transIconWidth_;
        if (x - x0 < rxWidth) {
            int ir = (x - x0) / this.transIconWidth_;
            return (Transmission)this.rxModel_.getElementAt(ir);
        }
        int targetWidth = this.targetIcon_.getIconWidth();
        if (x - (x0 += rxWidth) < targetWidth) {
            return null;
        }
        int txWidth = this.txModel_.getSize() * this.transIconWidth_;
        if (x - (x0 += targetWidth) < txWidth) {
            int it = (x - x0) / this.transIconWidth_;
            return (Transmission)this.txModel_.getElementAt(it);
        }
        if (!$assertionsDisabled && x <= (x0 += txWidth)) {
            throw new AssertionError();
        }
        return null;
    }

    public int getIconWidth() {
        return (this.rxModel_ != null ? this.rxModel_.getSize() * this.transIconWidth_ : 0) + this.targetIcon_.getIconWidth() + (this.txModel_ != null ? this.txModel_.getSize() * this.transIconWidth_ : 0);
    }

    public int getIconHeight() {
        return this.size_;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon transIcon;
        Transmission trans;
        int i;
        if (this.rxModel_ != null) {
            for (i = 0; i < this.rxModel_.getSize(); ++i) {
                trans = (Transmission)this.rxModel_.getElementAt(i);
                transIcon = this.getTransIcon(trans, false);
                transIcon.paintIcon(c, g, x, y);
                x += transIcon.getIconWidth();
            }
        }
        this.targetIcon_.paintIcon(c, g, x, y);
        x += this.targetIcon_.getIconWidth();
        if (this.txModel_ != null) {
            for (i = 0; i < this.txModel_.getSize(); ++i) {
                trans = (Transmission)this.txModel_.getElementAt(i);
                transIcon = this.getTransIcon(trans, true);
                transIcon.paintIcon(c, g, x, y);
                x += transIcon.getIconWidth();
            }
        }
    }

    private Icon getTransIcon(Transmission trans, final boolean isTx) {
        return new Icon(){

            public int getIconHeight() {
                return TransmissionListIcon.this.size_;
            }

            public int getIconWidth() {
                return TransmissionListIcon.this.transIconWidth_;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                int[] nArray;
                int xlo = x + 1;
                int xhi = x + TransmissionListIcon.this.transIconWidth_ - 1;
                if (isTx) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = xhi;
                    nArray2[1] = xlo;
                    nArray = nArray2;
                    nArray2[2] = xhi;
                } else {
                    int[] nArray3 = new int[3];
                    nArray3[0] = xlo;
                    nArray3[1] = xhi;
                    nArray = nArray3;
                    nArray3[2] = xlo;
                }
                int[] xs = nArray;
                int[] ys = new int[]{y, y + TransmissionListIcon.this.size_ / 2, y + TransmissionListIcon.this.size_ - 1};
                g.fillPolygon(xs, ys, 3);
            }
        };
    }

    public JComponent createBox(int nTrans) {
        return new TransmissionListBox(this, nTrans);
    }

    static {
        $assertionsDisabled = !TransmissionListIcon.class.desiredAssertionStatus();
    }

    private static class TransmissionListBox
    extends JComponent {
        private final TransmissionListIcon icon_;
        private final int nTrans_;
        private final boolean hasRx_;
        private final boolean hasTx_;
        private Dimension minSize_;

        TransmissionListBox(TransmissionListIcon icon, int nTrans) {
            this.icon_ = icon;
            this.nTrans_ = nTrans;
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            ListDataListener listener = new ListDataListener(this){
                private final /* synthetic */ TransmissionListBox this$0;
                {
                    this.this$0 = this$0;
                }

                public void contentsChanged(ListDataEvent evt) {
                    this.this$0.repaint();
                }

                public void intervalAdded(ListDataEvent evt) {
                    this.this$0.repaint();
                }

                public void intervalRemoved(ListDataEvent evt) {
                    this.this$0.repaint();
                }
            };
            this.hasRx_ = icon.rxModel_ != null;
            boolean bl = this.hasTx_ = icon.txModel_ != null;
            if (this.hasRx_) {
                icon.rxModel_.addListDataListener(listener);
            }
            if (this.hasTx_) {
                icon.txModel_.addListDataListener(listener);
            }
            this.setPreferredSize(this.getSizeForCount(nTrans));
            this.setMinimumSize(this.getSizeForCount(Math.max(nTrans, 4)));
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public Dimension getSizeForCount(int nTrans) {
            int width = this.icon_.targetIcon_.getIconWidth();
            int n = this.hasTx_ ? 1 : 0;
            int height = this.icon_.size_;
            Dimension size = new Dimension(width += ((this.hasRx_ ? 1 : 0) + n) * this.nTrans_ * this.icon_.transIconWidth_, height);
            Insets insets = this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        public String getToolTipText(MouseEvent evt) {
            Point p = evt.getPoint();
            Point iconPos = this.getIconPosition();
            p.x -= iconPos.x;
            p.y -= iconPos.y;
            Transmission trans = this.icon_.getTransmissionAt(p);
            if (trans != null) {
                return trans.getMessage().getMType() + ": " + trans.getSender().toString() + " -> " + trans.getReceiver().toString();
            }
            return null;
        }

        private Point getIconPosition() {
            Insets insets = this.getInsets();
            return new Point(insets.left, insets.top);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color color = g.getColor();
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(insets.left, insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
            }
            g.setColor(color);
            Point p = this.getIconPosition();
            this.icon_.paintIcon(this, g, p.x, p.y);
        }
    }
}

