/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.ResultHandler;
import org.astrogrid.samp.gui.AbstractCallActionManager;
import org.astrogrid.samp.gui.ErrorDialog;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.SendActionManager;
import org.astrogrid.samp.gui.SubscribedClientListModel;

public abstract class UniformCallActionManager
extends AbstractCallActionManager {
    private final Component parent_;
    private final String mtype_;
    private final String sendType_;
    static /* synthetic */ Class class$org$astrogrid$samp$gui$UniformCallActionManager;

    public UniformCallActionManager(Component parent, GuiHubConnector connector, String mtype, String sendType) {
        super(parent, connector, new SubscribedClientListModel(connector, mtype));
        this.parent_ = parent;
        this.mtype_ = mtype;
        this.sendType_ = sendType;
    }

    protected abstract Map createMessage() throws Exception;

    protected Map createMessage(Client client) throws Exception {
        return this.createMessage();
    }

    protected Action createBroadcastAction() {
        return new BroadcastAction();
    }

    public JMenu createSendMenu() {
        JMenu menu = super.createSendMenu("Send " + this.sendType_ + " to...");
        menu.setIcon(UniformCallActionManager.getSendIcon());
        return menu;
    }

    public Action getSendAction(Client client) {
        Action action = super.getSendAction(client);
        action.putValue("ShortDescription", "Transmit to " + client + " using SAMP " + this.mtype_);
        return action;
    }

    private class BroadcastAction
    extends AbstractAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        BroadcastAction() {
            this.putValue("Name", "Broadcast " + UniformCallActionManager.this.sendType_);
            this.putValue("ShortDescription", "Transmit " + UniformCallActionManager.this.sendType_ + " to all applications" + " listening using the SAMP protocol");
            this.putValue("SmallIcon", SendActionManager.getBroadcastIcon());
        }

        public void actionPerformed(ActionEvent evt) {
            GuiHubConnector connector = UniformCallActionManager.this.getConnector();
            Set recipientIdSet = null;
            Message msg = null;
            HubConnection connection = null;
            String tag = null;
            try {
                msg = Message.asMessage(UniformCallActionManager.this.createMessage());
                msg.check();
                connection = ((HubConnector)connector).getConnection();
                if (connection != null) {
                    tag = UniformCallActionManager.this.createTag();
                    recipientIdSet = connection.callAll(tag, msg).keySet();
                }
            }
            catch (Exception e) {
                ErrorDialog.showError(UniformCallActionManager.this.parent_, "Send Error", "Send failure " + e.getMessage(), e);
            }
            if (recipientIdSet != null) {
                if (!$assertionsDisabled && connection == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && msg == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && tag == null) {
                    throw new AssertionError();
                }
                ArrayList<Client> recipientList = new ArrayList<Client>();
                Map clientMap = connector.getClientMap();
                Iterator it = recipientIdSet.iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    Client recipient = (Client)clientMap.get(id);
                    if (recipient == null) continue;
                    recipientList.add(recipient);
                }
                Client[] recipients = recipientList.toArray(new Client[0]);
                ResultHandler handler = UniformCallActionManager.this.createResultHandler(connection, msg, recipients);
                if (recipients.length == 0) {
                    if (handler != null) {
                        handler.done();
                    }
                    handler = null;
                }
                UniformCallActionManager.this.registerHandler(tag, recipients, handler);
            }
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$UniformCallActionManager == null ? (class$org$astrogrid$samp$gui$UniformCallActionManager = UniformCallActionManager.class$("org.astrogrid.samp.gui.UniformCallActionManager")) : class$org$astrogrid$samp$gui$UniformCallActionManager).desiredAssertionStatus();
        }
    }
}

