/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.HubServiceException;
import org.astrogrid.samp.hub.Receiver;

class HubReceiver
implements Receiver {
    private final HubService hub_;
    private final Object clientId_;
    private final MessageHandler[] handlers_;

    public HubReceiver(HubService hub, Object clientId) {
        this(hub, clientId, HubReceiver.createDefaultHandlers());
    }

    private HubReceiver(HubService hub, Object clientId, MessageHandler[] handlers) {
        this.hub_ = hub;
        this.clientId_ = clientId;
        this.handlers_ = handlers;
    }

    public void receiveCall(String senderId, String msgId, Map message) throws HubServiceException {
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        for (int i = 0; i < this.handlers_.length; ++i) {
            Response response;
            MessageHandler handler = this.handlers_[i];
            if (!mtype.equals(handler.getMType())) continue;
            try {
                Map result = handler.processCall(senderId, msg);
                result = result == null ? new HashMap() : result;
                response = Response.createSuccessResponse(result);
            }
            catch (Exception e) {
                response = Response.createErrorResponse(new ErrInfo(e));
            }
            this.hub_.reply(this.clientId_, msgId, response);
            return;
        }
        throw new HubServiceException("Unsubscribed MType " + mtype);
    }

    public void receiveNotification(String senderId, Map message) throws HubServiceException {
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        for (int i = 0; i < this.handlers_.length; ++i) {
            MessageHandler handler = this.handlers_[i];
            if (!mtype.equals(handler.getMType())) continue;
            handler.processCall(senderId, msg);
            return;
        }
        throw new HubServiceException("Unsubscribed MType " + mtype);
    }

    public void receiveResponse(String responderId, String msgTag, Map response) throws HubServiceException {
        throw new HubServiceException("Not expecting any responses");
    }

    public Subscriptions getSubscriptions() {
        Subscriptions subs = new Subscriptions();
        for (int i = 0; i < this.handlers_.length; ++i) {
            subs.addMType(this.handlers_[i].getMType());
        }
        return subs;
    }

    private static MessageHandler[] createDefaultHandlers() {
        return new MessageHandler[]{new MessageHandler("samp.app.ping"){

            Map processCall(String senderId, Message msg) {
                return new HashMap();
            }
        }};
    }

    private static abstract class MessageHandler {
        private final String mtype_;

        MessageHandler(String mtype) {
            this.mtype_ = mtype;
        }

        public String getMType() {
            return this.mtype_;
        }

        abstract Map processCall(String var1, Message var2);
    }
}

