/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.xmlrpc.ClientXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;

class CallableClientServer {
    private final URL url_;
    private final ClientXmlRpcHandler clientHandler_ = new ClientXmlRpcHandler();
    private static final Map serverMap_ = new HashMap();

    public CallableClientServer(SampXmlRpcServer server) throws IOException {
        server.addHandler(this.clientHandler_);
        this.url_ = server.getEndpoint();
    }

    public URL getUrl() {
        return this.url_;
    }

    public void addClient(String privateKey, CallableClient callable) {
        this.clientHandler_.addClient(privateKey, callable);
    }

    public void removeClient(String privateKey) {
        this.clientHandler_.removeClient(privateKey);
    }

    public static synchronized CallableClientServer getInstance(SampXmlRpcServer server) throws IOException {
        if (!serverMap_.containsKey(server)) {
            serverMap_.put(server, new CallableClientServer(server));
        }
        return (CallableClientServer)serverMap_.get(server);
    }
}

