/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.xmlrpc.ActorHandler;
import org.astrogrid.samp.xmlrpc.ClientActor;

class ClientXmlRpcHandler
extends ActorHandler {
    private final ClientActorImpl clientActor_ = (ClientActorImpl)this.getActor();

    public ClientXmlRpcHandler() {
        super("samp.client", ClientActor.class, new ClientActorImpl());
    }

    public void addClient(String privateKey, CallableClient callable) {
        this.clientActor_.map_.put(privateKey, callable);
    }

    public void removeClient(String privateKey) {
        this.clientActor_.map_.remove(privateKey);
    }

    private static class ClientActorImpl
    implements ClientActor {
        private final Map map_ = new HashMap();

        private ClientActorImpl() {
        }

        public void receiveNotification(String privateKey, String senderId, Map msg) throws Exception {
            this.getCallable(privateKey).receiveNotification(senderId, Message.asMessage(msg));
        }

        public void receiveCall(String privateKey, String senderId, String msgId, Map msg) throws Exception {
            this.getCallable(privateKey).receiveCall(senderId, msgId, Message.asMessage(msg));
        }

        public void receiveResponse(String privateKey, String responderId, String msgTag, Map response) throws Exception {
            this.getCallable(privateKey).receiveResponse(responderId, msgTag, Response.asResponse(response));
        }

        private CallableClient getCallable(String privateKey) {
            Object cc = this.map_.get(privateKey);
            if (cc instanceof CallableClient) {
                return (CallableClient)cc;
            }
            throw new IllegalStateException("Client is not listening");
        }
    }
}

