/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.xmlrpc.CallableClientServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;

public class XmlRpcHubConnection
implements HubConnection {
    private final SampXmlRpcClient xClient_;
    private final SampXmlRpcServerFactory serverFactory_;
    private final RegInfo regInfo_;
    private CallableClientServer callableServer_;
    private boolean unregistered_;

    public XmlRpcHubConnection(SampXmlRpcClient xClient, SampXmlRpcServerFactory serverFactory, String secret) throws SampException {
        this.xClient_ = xClient;
        this.serverFactory_ = serverFactory;
        Object regInfo = this.rawExec("samp.hub.register", Collections.singletonList(secret));
        if (!(regInfo instanceof Map)) {
            throw new SampException("Bad return value from hub register method - not a map");
        }
        this.regInfo_ = RegInfo.asRegInfo(Collections.unmodifiableMap(this.asMap(regInfo)));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                XmlRpcHubConnection.this.finish();
            }
        });
    }

    public RegInfo getRegInfo() {
        return this.regInfo_;
    }

    public void ping() throws SampException {
        this.rawExec("samp.hub.ping", new ArrayList());
    }

    public void setCallable(CallableClient callable) throws SampException {
        if (this.callableServer_ == null) {
            try {
                this.callableServer_ = CallableClientServer.getInstance(this.serverFactory_.getServer());
            }
            catch (IOException e) {
                throw new SampException("Can't start client XML-RPC server", e);
            }
        }
        this.callableServer_.addClient(this.regInfo_.getPrivateKey(), callable);
        this.exec("setXmlrpcCallback", new Object[]{this.callableServer_.getUrl().toString()});
    }

    public void unregister() throws SampException {
        this.exec("unregister", new Object[0]);
        if (this.callableServer_ != null) {
            this.callableServer_.removeClient(this.regInfo_.getPrivateKey());
        }
        this.unregistered_ = true;
    }

    public void declareMetadata(Map meta) throws SampException {
        this.exec("declareMetadata", new Object[]{meta});
    }

    public Metadata getMetadata(String clientId) throws SampException {
        return Metadata.asMetadata(this.asMap(this.exec("getMetadata", new Object[]{clientId})));
    }

    public void declareSubscriptions(Map subs) throws SampException {
        this.exec("declareSubscriptions", new Object[]{subs});
    }

    public Subscriptions getSubscriptions(String clientId) throws SampException {
        return Subscriptions.asSubscriptions(this.asMap(this.exec("getSubscriptions", new Object[]{clientId})));
    }

    public String[] getRegisteredClients() throws SampException {
        return this.asList(this.exec("getRegisteredClients", new Object[0])).toArray(new String[0]);
    }

    public Map getSubscribedClients(String mtype) throws SampException {
        return this.asMap(this.exec("getSubscribedClients", new Object[]{mtype}));
    }

    public void notify(String recipientId, Map msg) throws SampException {
        this.exec("notify", new Object[]{recipientId, msg});
    }

    public List notifyAll(Map msg) throws SampException {
        return this.asList(this.exec("notifyAll", new Object[]{msg}));
    }

    public String call(String recipientId, String msgTag, Map msg) throws SampException {
        return this.asString(this.exec("call", new Object[]{recipientId, msgTag, msg}));
    }

    public Map callAll(String msgTag, Map msg) throws SampException {
        return this.asMap(this.exec("callAll", new Object[]{msgTag, msg}));
    }

    public Response callAndWait(String recipientId, Map msg, int timeout) throws SampException {
        return Response.asResponse(this.asMap(this.exec("callAndWait", new Object[]{recipientId, msg, SampUtils.encodeInt(timeout)})));
    }

    public void reply(String msgId, Map response) throws SampException {
        this.exec("reply", new Object[]{msgId, response});
    }

    private Object exec(String methodName, Object[] params) throws SampException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(this.regInfo_.getPrivateKey());
        for (int ip = 0; ip < params.length; ++ip) {
            paramList.add(params[ip]);
        }
        return this.rawExec("samp.hub." + methodName, paramList);
    }

    private Object rawExec(String fqName, List paramList) throws SampException {
        try {
            return this.xClient_.callAndWait(fqName, paramList);
        }
        catch (IOException e) {
            throw new SampException(e.getMessage(), e);
        }
    }

    private void finish() {
        if (!this.unregistered_) {
            try {
                this.unregister();
            }
            catch (SampException sampException) {
                // empty catch block
            }
        }
    }

    public void finalize() throws Exception {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.finish();
    }

    private static Object asType(Object obj, Class clazz, String name) throws SampException {
        if (clazz.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        throw new SampException("Hub returned unexpected type (" + obj.getClass().getName() + " not " + name);
    }

    private String asString(Object obj) throws SampException {
        return (String)XmlRpcHubConnection.asType(obj, String.class, "string");
    }

    private List asList(Object obj) throws SampException {
        return (List)XmlRpcHubConnection.asType(obj, List.class, "list");
    }

    private Map asMap(Object obj) throws SampException {
        return (Map)XmlRpcHubConnection.asType(obj, Map.class, "map");
    }
}

