/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.internal.InternalServer;

public class RpcLoggingInternalServer
extends InternalServer {
    private final PrintStream out_;

    public RpcLoggingInternalServer(HttpServer server, String path, PrintStream out) throws IOException {
        super(server, path);
        this.out_ = out;
    }

    public RpcLoggingInternalServer(PrintStream out) throws IOException {
        this.out_ = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleCall(SampXmlRpcHandler handler, String methodName, List paramList) throws Exception {
        Object result;
        String paramString = SampUtils.formatObject(paramList, 2);
        PrintStream printStream = this.out_;
        synchronized (printStream) {
            this.out_.println("SERVER IN:");
            this.out_.println(methodName);
            this.out_.println(paramString);
            this.out_.println();
        }
        try {
            result = super.handleCall(handler, methodName, paramList);
        }
        catch (Throwable e) {
            PrintStream printStream2 = this.out_;
            synchronized (printStream2) {
                this.out_.println("SERVER ERROR:");
                this.out_.println(methodName);
                e.printStackTrace(this.out_);
                this.out_.println();
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (Exception)e;
        }
        String resultString = SampUtils.formatObject(result, 2);
        PrintStream printStream3 = this.out_;
        synchronized (printStream3) {
            this.out_.println("SERVER OUT:");
            this.out_.println(methodName);
            this.out_.println(resultString);
            this.out_.println();
        }
        return result;
    }
}

