/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.astrogrid.samp.xmlrpc.internal.XmlRpcFormatException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlUtils {
    private static Logger logger_ = Logger.getLogger(XmlUtils.class.getName());

    private XmlUtils() {
    }

    public static Element[] getChildren(Node parent) {
        NodeList nodeList = parent.getChildNodes();
        int nnode = nodeList.getLength();
        ArrayList<Element> elList = new ArrayList<Element>(nnode);
        for (int i = 0; i < nnode; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            elList.add((Element)node);
        }
        return elList.toArray(new Element[0]);
    }

    public static Element getChild(Node parent) throws XmlRpcFormatException {
        Element[] els = XmlUtils.getChildren(parent);
        if (els.length == 1) {
            return els[0];
        }
        if (els.length == 0) {
            throw new XmlRpcFormatException("No child element of " + ((Element)parent).getTagName());
        }
        throw new XmlRpcFormatException("Multiple children of " + ((Element)parent).getTagName());
    }

    public static Element getChild(Node parent, String tagName) throws XmlRpcFormatException {
        Element child = XmlUtils.getChild(parent);
        if (!tagName.equals(child.getTagName())) {
            throw new XmlRpcFormatException("Unexpected child of " + ((Element)parent).getTagName() + ": " + child.getTagName() + " is not " + tagName);
        }
        return child;
    }

    public static String getTextContent(Element el) throws XmlRpcFormatException {
        StringBuffer sbuf = new StringBuffer();
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof Text) {
                sbuf.append(((Text)node).getData());
                continue;
            }
            if (!(node instanceof Element)) continue;
            throw new XmlRpcFormatException("Unexpected node " + node + " in " + el.getTagName() + " content");
        }
        return sbuf.toString();
    }

    public static Object parseSampValue(Element valueEl) throws XmlRpcFormatException {
        if (XmlUtils.getChildren(valueEl).length == 0) {
            return XmlUtils.getTextContent(valueEl);
        }
        Element el = XmlUtils.getChild(valueEl);
        String name = el.getTagName();
        if ("array".equals(name)) {
            Element[] valueEls = XmlUtils.getChildren(XmlUtils.getChild(el, "data"));
            int nel = valueEls.length;
            ArrayList<Object> list = new ArrayList<Object>(nel);
            for (int i = 0; i < nel; ++i) {
                list.add(XmlUtils.parseSampValue(valueEls[i]));
            }
            return list;
        }
        if ("struct".equals(name)) {
            Element[] memberEls = XmlUtils.getChildren(el);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < memberEls.length; ++i) {
                Element member = memberEls[i];
                if (!"member".equals(member.getTagName())) {
                    throw new XmlRpcFormatException("Non-<member> child of <struct>: " + member.getTagName());
                }
                Element[] memberChildren = XmlUtils.getChildren(member);
                String key = null;
                Object value = null;
                for (int j = 0; j < memberChildren.length; ++j) {
                    Element memberChild = memberChildren[j];
                    String memberName = memberChild.getTagName();
                    if ("name".equals(memberName)) {
                        key = XmlUtils.getTextContent(memberChild);
                        continue;
                    }
                    if (!"value".equals(memberName)) continue;
                    value = XmlUtils.parseSampValue(memberChild);
                }
                if (key == null) {
                    throw new XmlRpcFormatException("<name> missing in struct member");
                }
                if (value == null) {
                    throw new XmlRpcFormatException("<value> missing in struct member");
                }
                if (map.containsKey(key)) {
                    logger_.warning("Re-used key " + key + " in map");
                }
                map.put(key, value);
            }
            return map;
        }
        if ("string".equals(name)) {
            return XmlUtils.getTextContent(el);
        }
        if ("i4".equals(name) || "int".equals(name)) {
            String text = XmlUtils.getTextContent(el);
            try {
                return Integer.valueOf(text);
            }
            catch (NumberFormatException e) {
                throw new XmlRpcFormatException("Bad int " + text);
            }
        }
        if ("boolean".equals(name)) {
            String text = XmlUtils.getTextContent(el);
            if ("0".equals(text)) {
                return Boolean.FALSE;
            }
            if ("1".equals(text)) {
                return Boolean.TRUE;
            }
            throw new XmlRpcFormatException("Bad boolean " + text);
        }
        if ("double".equals(name)) {
            String text = XmlUtils.getTextContent(el);
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException e) {
                throw new XmlRpcFormatException("Bad double " + text);
            }
        }
        if ("dateTime.iso8601".equals(name) || "base64".equals(name)) {
            throw new XmlRpcFormatException(name + " not used in SAMP");
        }
        throw new XmlRpcFormatException("Unknown XML-RPC element <" + name + ">");
    }
}

