/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.vo.ConeSearch;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.KeywordServiceQueryFactory;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryServiceTableLoadDialog;
import uk.ac.starlink.vo.SkyPositionEntry;

public class ConeSearchDialog
extends RegistryServiceTableLoadDialog {
    private final SkyPositionEntry skyEntry_ = new SkyPositionEntry("J2000");
    private final DoubleValueField raField_ = this.skyEntry_.getRaDegreesField();
    private final DoubleValueField decField_ = this.skyEntry_.getDecDegreesField();
    private final DoubleValueField srField_ = DoubleValueField.makeSizeDegreesField(SR_INFO);
    private static final ValueInfo SR_INFO = new DefaultValueInfo("Radius", Double.class, "Search Radius");

    public ConeSearchDialog() {
        super("Cone Search", "Obtain source catalogues using cone search web services", new KeywordServiceQueryFactory("ivo://ivoa.net/std/ConeSearch"), true);
        this.skyEntry_.addField(this.srField_);
        this.skyEntry_.addActionListener(this.getOkAction());
        this.getControlBox().add(this.skyEntry_);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.skyEntry_.setEnabled(enabled);
    }

    public RegCapabilityInterface[] getCapabilities(RegResource resource) {
        RegCapabilityInterface[] caps = super.getCapabilities(resource);
        ArrayList<RegCapabilityInterface> cscapList = new ArrayList<RegCapabilityInterface>();
        for (int i = 0; i < caps.length; ++i) {
            if (!"ivo://ivoa.net/std/ConeSearch".equals(caps[i].getStandardId())) continue;
            cscapList.add(caps[i]);
        }
        return cscapList.toArray(new RegCapabilityInterface[0]);
    }

    protected BasicTableLoadDialog.TableSupplier getTableSupplier() {
        RegResource[] resources = this.getRegistryPanel().getSelectedResources();
        RegCapabilityInterface[] capabilities = this.getRegistryPanel().getSelectedCapabilities();
        if (resources.length != 1 || capabilities.length != 1) {
            throw new IllegalStateException("No cone search service selected");
        }
        RegResource resource = resources[0];
        RegCapabilityInterface capability = capabilities[0];
        final ConeSearch coner = new ConeSearch(resource, capability);
        final double ra = this.raField_.getValue();
        final double dec = this.decField_.getValue();
        final double sr = this.srField_.getValue();
        boolean verb = false;
        final ArrayList<DescribedValue> metadata = new ArrayList<DescribedValue>();
        metadata.addAll(Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.srField_.getDescribedValue()));
        metadata.addAll(Arrays.asList(ConeSearch.getMetadata(resource, capability)));
        return new BasicTableLoadDialog.TableSupplier(){

            public StarTable getTable(StarTableFactory factory, String format) throws IOException {
                StarTable st = coner.performSearch(ra, dec, sr, 0, factory);
                st.getParameters().addAll(metadata);
                return st;
            }

            public String getTableID() {
                return coner.toString();
            }
        };
    }
}

