/*
 * Decompiled with CFR 0.152.
 */
package alma.common.calibratorCatalogue.calQueryParameters;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class CalQueryParameters
implements Serializable {
    private double _rightAscension = 0.0;
    private boolean _has_rightAscension;
    private double _declination = 0.0;
    private boolean _has_declination;
    private double _radius = 0.0;
    private boolean _has_radius;
    private double _minFrequency = 0.0;
    private boolean _has_minFrequency;
    private double _maxFrequency = 0.0;
    private boolean _has_maxFrequency;
    private double _minFlux = 0.0;
    private boolean _has_minFlux;
    private double _maxFlux = 0.0;
    private boolean _has_maxFlux;
    private Date _earliestObservation;
    private Date _latestObservation;
    private CalibrationUseType _calibrationUse = CalibrationUseType.valueOf("UNDEFINED");

    public CalQueryParameters() {
        this.setCalibrationUse(CalibrationUseType.valueOf("UNDEFINED"));
    }

    public void deleteDeclination() {
        this._has_declination = false;
    }

    public void deleteMaxFlux() {
        this._has_maxFlux = false;
    }

    public void deleteMaxFrequency() {
        this._has_maxFrequency = false;
    }

    public void deleteMinFlux() {
        this._has_minFlux = false;
    }

    public void deleteMinFrequency() {
        this._has_minFrequency = false;
    }

    public void deleteRadius() {
        this._has_radius = false;
    }

    public void deleteRightAscension() {
        this._has_rightAscension = false;
    }

    public CalibrationUseType getCalibrationUse() {
        return this._calibrationUse;
    }

    public double getDeclination() {
        return this._declination;
    }

    public Date getEarliestObservation() {
        return this._earliestObservation;
    }

    public Date getLatestObservation() {
        return this._latestObservation;
    }

    public double getMaxFlux() {
        return this._maxFlux;
    }

    public double getMaxFrequency() {
        return this._maxFrequency;
    }

    public double getMinFlux() {
        return this._minFlux;
    }

    public double getMinFrequency() {
        return this._minFrequency;
    }

    public double getRadius() {
        return this._radius;
    }

    public double getRightAscension() {
        return this._rightAscension;
    }

    public boolean hasDeclination() {
        return this._has_declination;
    }

    public boolean hasMaxFlux() {
        return this._has_maxFlux;
    }

    public boolean hasMaxFrequency() {
        return this._has_maxFrequency;
    }

    public boolean hasMinFlux() {
        return this._has_minFlux;
    }

    public boolean hasMinFrequency() {
        return this._has_minFrequency;
    }

    public boolean hasRadius() {
        return this._has_radius;
    }

    public boolean hasRightAscension() {
        return this._has_rightAscension;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void setCalibrationUse(CalibrationUseType calibrationUse) {
        this._calibrationUse = calibrationUse;
    }

    public void setDeclination(double declination) {
        this._declination = declination;
        this._has_declination = true;
    }

    public void setEarliestObservation(Date earliestObservation) {
        this._earliestObservation = earliestObservation;
    }

    public void setLatestObservation(Date latestObservation) {
        this._latestObservation = latestObservation;
    }

    public void setMaxFlux(double maxFlux) {
        this._maxFlux = maxFlux;
        this._has_maxFlux = true;
    }

    public void setMaxFrequency(double maxFrequency) {
        this._maxFrequency = maxFrequency;
        this._has_maxFrequency = true;
    }

    public void setMinFlux(double minFlux) {
        this._minFlux = minFlux;
        this._has_minFlux = true;
    }

    public void setMinFrequency(double minFrequency) {
        this._minFrequency = minFrequency;
        this._has_minFrequency = true;
    }

    public void setRadius(double radius) {
        this._radius = radius;
        this._has_radius = true;
    }

    public void setRightAscension(double rightAscension) {
        this._rightAscension = rightAscension;
        this._has_rightAscension = true;
    }

    public static CalQueryParameters unmarshalCalQueryParameters(Reader reader) throws MarshalException, ValidationException {
        return (CalQueryParameters)Unmarshaller.unmarshal(CalQueryParameters.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

