/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IntArray
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8356201427005323616L;
    private static final int DEFAULT_CAPACITY = 10;
    protected transient int[] data;
    private transient int pos;

    public IntArray() {
        this(10);
    }

    public IntArray(int capacity) {
        this.data = new int[capacity];
        this.pos = 0;
    }

    public IntArray(int[] values) {
        this(Math.max(values.length, 10));
        this.add(values);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            int newCap = Math.max(this.data.length << 1, capacity);
            int[] tmp = new int[newCap];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    public int size() {
        return this.pos;
    }

    public boolean isEmpty() {
        return this.pos == 0;
    }

    public void trimToSize() {
        if (this.data.length > this.size()) {
            int[] tmp = new int[this.size()];
            this.toArray(tmp, 0, tmp.length);
            this.data = tmp;
        }
    }

    public void add(int val) {
        this.ensureCapacity(this.pos + 1);
        this.data[this.pos++] = val;
    }

    public void add(int[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(int[] vals, int offset, int length) {
        this.ensureCapacity(this.pos + length);
        System.arraycopy(vals, offset, this.data, this.pos, length);
        this.pos += length;
    }

    public void insert(int offset, int value) {
        if (offset == this.pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this.pos + 1);
        System.arraycopy(this.data, offset, this.data, offset + 1, this.pos - offset);
        this.data[offset] = value;
        ++this.pos;
    }

    public void insert(int offset, int[] values) {
        this.insert(offset, values, 0, values.length);
    }

    public void insert(int offset, int[] values, int valOffset, int len) {
        if (offset == this.pos) {
            this.add(values, valOffset, len);
            return;
        }
        this.ensureCapacity(this.pos + len);
        System.arraycopy(this.data, offset, this.data, offset + len, this.pos - offset);
        System.arraycopy(values, valOffset, this.data, offset, len);
        this.pos += len;
    }

    public int get(int offset) {
        if (offset >= this.pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this.data[offset];
    }

    public void set(int offset, int val) {
        if (offset >= this.pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this.data[offset] = val;
    }

    public void set(int offset, int[] values) {
        this.set(offset, values, 0, values.length);
    }

    public void set(int offset, int[] values, int valOffset, int length) {
        if (offset < 0 || offset + length >= this.pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this.data, offset, values, valOffset, length);
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this.data = new int[capacity];
        this.pos = 0;
    }

    public int removeAt(int offset) {
        int old = this.get(offset);
        this.removeAt(offset, 1);
        return old;
    }

    public int remove(int value) {
        int i = this.pos;
        while (i-- > 0) {
            if (this.data[i] != value) continue;
            this.removeAt(i, 1);
            return i;
        }
        return -1;
    }

    public void removeAt(int offset, int length) {
        if (offset < 0 || offset >= this.pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this.data, length, this.data, 0, this.pos - length);
        } else if (this.pos - length != offset) {
            System.arraycopy(this.data, offset + length, this.data, offset, this.pos - (offset + length));
        }
        this.pos -= length;
    }

    public Object clone() {
        IntArray clone = null;
        try {
            clone = (IntArray)super.clone();
            clone.data = (int[])this.data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public int[] toArray() {
        return this.toArray(0, this.pos);
    }

    public int[] toArray(int offset, int len) {
        int[] rv = new int[len];
        this.toArray(rv, offset, len);
        return rv;
    }

    public void toArray(int[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this.pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this.data, offset, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IntArray) {
            IntArray that = (IntArray)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this.pos;
            while (i-- > 0) {
                if (this.data[i] == that.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this.pos;
        while (i-- > 0) {
            h += this.data[i];
        }
        return h;
    }

    public boolean contains(int value) {
        int i = this.pos;
        while (i-- > 0) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < this.pos; ++i) {
            buf.append(this.data[i]);
            if (i == this.pos - 1) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.pos);
        for (int i = 0; i < this.pos; ++i) {
            stream.writeInt(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.data = new int[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = stream.readInt();
        }
        this.pos = size;
    }
}

