/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ProfilingReentrantLock
implements Lock {
    private final ReentrantLock delegate;
    private final String lockName;
    public static final String PROFILING_ENABLED_PROPERTYNAME = "acs.enableReentrantLockProfiling";
    public static final boolean isProfilingEnabled = Boolean.getBoolean("acs.enableReentrantLockProfiling");
    private Map<Long, LockInfo> lockInfoMap = new HashMap<Long, LockInfo>();

    public ProfilingReentrantLock(String lockName) {
        this.lockName = lockName;
        this.delegate = new ReentrantLock();
    }

    public static Lock createReentrantLock(String lockName) {
        if (isProfilingEnabled) {
            return new ProfilingReentrantLock(lockName);
        }
        return new ReentrantLock();
    }

    @Override
    public void lock() {
        if (!this.delegate.isHeldByCurrentThread()) {
            String codeId = this.createCodeId(1);
            long t0 = System.currentTimeMillis();
            int queueLength = this.delegate.getQueueLength();
            LockInfo lockInfo = new LockInfo(codeId, t0, queueLength);
            this.lockInfoMap.put(Thread.currentThread().getId(), lockInfo);
            this.delegate.lock();
            lockInfo.timeLocked = System.currentTimeMillis();
        } else {
            this.delegate.lock();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException("lockInterruptibly not yet supported");
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException("tryLock not yet supported");
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("tryLock not yet supported");
    }

    @Override
    public void unlock() {
        this.delegate.unlock();
        if (!this.delegate.isHeldByCurrentThread()) {
            LockInfo lockInfo = this.lockInfoMap.remove(Thread.currentThread().getId());
            lockInfo.timeUnlocked = System.currentTimeMillis();
            this.printProfilingMessage(lockInfo, Thread.currentThread().getName());
        }
    }

    @Override
    public Condition newCondition() {
        return this.delegate.newCondition();
    }

    String createCodeId(int skipLevels) {
        String ret = null;
        StackTraceElement[] stackTraceElems = new Throwable().getStackTrace();
        ret = stackTraceElems.length >= skipLevels + 1 ? stackTraceElems[skipLevels + 1].getFileName() + "/" + stackTraceElems[skipLevels + 1].getLineNumber() : "<unknown>";
        return ret;
    }

    private void printProfilingMessage(LockInfo lockInfo, String threadName) {
        System.out.println("Profiling for lock '" + this.lockName + "' used in code='" + lockInfo.codeId + "', thread='" + threadName + "': queueLength=" + lockInfo.queueLength + ", acquiredMillis=" + (lockInfo.timeLocked - lockInfo.timeAttempted) + ", heldMillis=" + (lockInfo.timeUnlocked - lockInfo.timeLocked));
    }

    private static class LockInfo {
        final String codeId;
        final long timeAttempted;
        final int queueLength;
        long timeLocked;
        long timeUnlocked;

        public LockInfo(String codeId, long timeAttempted, int queueLength) {
            this.codeId = codeId;
            this.timeAttempted = timeAttempted;
            this.queueLength = queueLength;
        }
    }
}

