/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager.app;

import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigException;
import com.cosylab.CDB.DALOperations;
import com.cosylab.acs.maci.CoreException;
import com.cosylab.acs.maci.manager.ManagerImpl;
import com.cosylab.acs.maci.manager.ManagerShutdown;
import com.cosylab.acs.maci.manager.app.ManagerContainerServices;
import com.cosylab.acs.maci.manager.app.ManagerOrbProfiler;
import com.cosylab.acs.maci.manager.app.RecoveryFilesRemover;
import com.cosylab.acs.maci.manager.app.RecoverySnapshotTask;
import com.cosylab.acs.maci.plug.CORBAReferenceSerializator;
import com.cosylab.acs.maci.plug.CORBATransport;
import com.cosylab.acs.maci.plug.DefaultCORBAService;
import com.cosylab.acs.maci.plug.ManagerProxyImpl;
import com.cosylab.acs.maci.plug.NamingServiceRemoteDirectory;
import com.cosylab.cdb.client.CDBAccess;
import com.cosylab.util.FileHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import org.jacorb.orb.acs.AcsORBProfiler;
import org.jacorb.orb.acs.AcsProfilingORB;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.prevayler.PrevalentSystem;
import org.prevayler.Prevayler;
import org.prevayler.implementation.SnapshotPrevayler;
import si.ijs.maci.Manager;
import si.ijs.maci.ManagerHelper;

public class ManagerEngine {
    private static final String MANAGER_DOMAIN = "";
    private static final byte[] MANAGER_ID = new byte[]{77, 97, 110, 97, 103, 101, 114};
    private static final String RECOVERY_DIR_NAME = "Manager_Recovery";
    private ManagerImpl manager = null;
    private ManagerProxyImpl managerProxy = null;
    private POA managerPOA = null;
    private Manager managerReference = null;
    private ManagerShutdown shutdownImplementation = null;
    private String recoveryLocation = null;
    private AcsLogger logger = AcsLogger.fromJdkLogger((Logger)Logger.global, (String)"ur-logger");
    private DefaultCORBAService corbaService = null;
    public static final String DISABLE_PREVAYLER = "acs.disablePrevayler";
    private static final boolean isPrevaylerDisabled = Boolean.getBoolean("acs.disablePrevayler");

    public ManagerEngine(ManagerShutdown shutdownImplementation) {
        this.shutdownImplementation = shutdownImplementation;
    }

    public void destroy() {
        try {
            this.destroyManager();
        }
        catch (Throwable th) {
            this.logger.log(Level.SEVERE, "Failed to deactivate Manager.", th);
        }
    }

    public void initialize() {
        block2: {
            try {
                this.initializeManager();
                this.initializeShutdownHook();
            }
            catch (Throwable ex) {
                this.logger.log(Level.SEVERE, "FAILED TO INITIALIZE MANAGER.", ex);
                if (System.getProperty("ACS.noExit", "false").equalsIgnoreCase("true")) break block2;
                System.exit(1);
            }
        }
        this.logger.info("All initializations done.");
    }

    private void initializeManager() throws Throwable {
        this.logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("Manager", true);
        this.logger.info("Initializing Manager.");
        this.corbaService = new DefaultCORBAService((Logger)this.logger);
        final ORB orb = this.corbaService.getORB();
        if (orb == null) {
            CoreException ce = new CoreException("CORBA Service can not provide ORB.");
            throw ce;
        }
        POA rootPOA = this.corbaService.getRootPOA();
        if (rootPOA == null) {
            CoreException ce = new CoreException("CORBA Service can not provide RootPOA.");
            throw ce;
        }
        NamingServiceRemoteDirectory remoteDirectory = new NamingServiceRemoteDirectory(orb, (Logger)this.logger);
        Context context = null;
        if (remoteDirectory != null) {
            context = remoteDirectory.getContext();
        }
        Policy[] policies = new Policy[]{rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
        this.managerPOA = rootPOA.create_POA("ManagerPOA", rootPOA.the_POAManager(), policies);
        for (int i = 0; i < policies.length; ++i) {
            policies[i].destroy();
        }
        CORBAReferenceSerializator.setOrb(orb);
        this.manager = new ManagerImpl();
        this.manager.setDomain(MANAGER_DOMAIN);
        this.recoveryLocation = FileHelper.getTempFileName(null, (String)RECOVERY_DIR_NAME);
        String readRecovery = System.getProperties().getProperty("Manager.recovery", "true");
        if (readRecovery.equalsIgnoreCase("false")) {
            int i;
            File recoveryDir = new File(this.recoveryLocation);
            File[] files = recoveryDir.listFiles();
            for (i = 0; files != null && i < files.length; ++i) {
                files[i].delete();
            }
            files = recoveryDir.listFiles();
            for (i = 0; files != null && i < files.length; ++i) {
                if (!files[i].getName().endsWith(".commandLog")) continue;
                throw new Exception("Some recovery files are left in recovery location probably because of permission\nUnable to start without recovery state!");
            }
        } else {
            RecoveryFilesRemover.removeRecoveryFiles(new File(this.recoveryLocation));
        }
        SnapshotPrevayler prevayler = null;
        if (isPrevaylerDisabled) {
            System.out.println("Prevayler disabled!");
        } else {
            prevayler = new SnapshotPrevayler((PrevalentSystem)this.manager, this.recoveryLocation);
            if (readRecovery.equalsIgnoreCase("false")) {
                System.out.println("Skipping saved manager state!");
            }
            this.manager = (ManagerImpl)prevayler.system();
        }
        CDBAccess cdbAccess = new CDBAccess(orb, (Logger)this.logger);
        LogConfig logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
        logConfig.setCDBLoggingConfigPath("MACI/Managers/Manager");
        logConfig.setCDB((DALOperations)cdbAccess.connectAndGetDAL());
        try {
            logConfig.initialize(false);
        }
        catch (LogConfigException ex) {
            this.logger.log(Level.FINE, "Failed to configure logging (default values will be used). Reason: " + ex.getMessage());
        }
        ManagerContainerServices managerContainerServices = new ManagerContainerServices(orb, this.managerPOA, cdbAccess.getDAL(), (Logger)this.logger);
        this.manager.initialize((Prevayler)prevayler, cdbAccess, context, (Logger)this.logger, managerContainerServices);
        this.manager.setShutdownImplementation(this.shutdownImplementation);
        try {
            if (orb instanceof AcsProfilingORB) {
                ManagerOrbProfiler profiler = new ManagerOrbProfiler(this.manager, this.logger);
                ((AcsProfilingORB)orb).registerAcsORBProfiler((AcsORBProfiler)profiler);
                this.logger.finer("Orb profiling set up, using class " + ManagerOrbProfiler.class.getName());
            }
        }
        catch (Throwable th) {
            this.logger.log(Level.WARNING, "Failed to setup ORB profiling.", th);
        }
        if (prevayler != null) {
            FileHelper.setFileAttributes((String)"g+w", (String)this.recoveryLocation);
            long MINUTE_IN_MS = 60000L;
            new RecoverySnapshotTask(prevayler, 60000L, this.recoveryLocation, this.manager.getStatePersitenceFlag());
        }
        this.managerProxy = new ManagerProxyImpl(this.manager, (Logger)this.logger);
        this.managerPOA.activate_object_with_id(MANAGER_ID, (Servant)this.managerProxy);
        Object obj = this.managerPOA.servant_to_reference((Servant)this.managerProxy);
        this.managerReference = ManagerHelper.narrow((Object)obj);
        String ior = orb.object_to_string((Object)this.managerReference);
        this.logger.info("Manager activated with " + ior);
        this.manager.setManagerComponentReference(this.managerReference);
        this.manager.setTransport(new CORBATransport(orb, ior));
        if (remoteDirectory != null) {
            String reference = remoteDirectory.getReference();
            if (reference != null && reference.startsWith("iiop://")) {
                reference = (reference = reference.replaceFirst("iiop://", "corbaloc::")).charAt(reference.length() - 1) != '/' ? reference + "/NameService" : reference + "NameService";
            }
            try {
                obj = NamingContextHelper.narrow((Object)orb.string_to_object(reference));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error getting the NameServer. Manager exiting...");
                this.shutdownImplementation.shutdown(false);
            }
            this.manager.setRemoteDirectoryComponentReference(obj);
        }
        Hashtable<String, String> federationDirectoryProperties = new Hashtable<String, String>();
        federationDirectoryProperties.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        federationDirectoryProperties.put("java.naming.corba.orb", (String)orb);
        this.manager.initializeFederation(federationDirectoryProperties);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ClientLogManager.getAcsLogManager().initRemoteLogging(orb, ManagerEngine.this.managerReference, ManagerEngine.this.manager.getHandle(), true);
            }
        }, "Remote logging initializer").start();
        this.manager.initializationDone();
    }

    private void destroyManager() throws Exception {
        this.logger.info("Destroying Manager.");
        if (!this.manager.isShuttingDown()) {
            try {
                this.manager.shutdown(0x5000000, 0);
            }
            catch (Throwable ex) {
                CoreException ce = new CoreException("Failed to destroy manager.", ex);
                this.logger.log(Level.WARNING, "Failed to destroy manager.", (Throwable)ce);
            }
        }
        if (this.managerPOA != null && this.managerReference != null) {
            this.managerPOA.deactivate_object(MANAGER_ID);
            this.managerPOA = null;
        }
        if (this.corbaService != null) {
            this.corbaService.destroy();
        }
        if (this.recoveryLocation != null) {
            FileHelper.setFileAttributes((String)"g+w", (String)this.recoveryLocation);
        }
    }

    private void initializeShutdownHook() {
        class ManagerShutdownHookThread
        extends Thread {
            public ManagerShutdownHookThread() {
                super("ManagerShutdownHook");
            }

            @Override
            public void run() {
                if (ManagerEngine.this.shutdownImplementation != null && !ManagerEngine.this.shutdownImplementation.isShutdownInProgress()) {
                    ManagerEngine.this.shutdownImplementation.shutdown(true);
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new ManagerShutdownHookThread());
    }

    public int getNumberOfPendingRequests() {
        if (this.managerProxy != null) {
            return this.managerProxy.getNumberOfPendingRequests();
        }
        return -1;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

