/*
 * Decompiled with CFR 0.152.
 */
package alma.maci.containerconfig;

import alma.maci.cdbtypes.Array;
import alma.maci.containerconfig.DeployInfo;
import alma.maci.containerconfig.types.ContainerImplLangType;
import alma.maci.loggingconfig.LoggingConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Container
implements Serializable {
    private ContainerImplLangType _implLang;
    private double _timeout = 30.0;
    private boolean _has_timeout;
    private boolean _useIFR = true;
    private boolean _has_useIFR;
    private int _managerRetry = 10;
    private boolean _has_managerRetry;
    private int _pingInterval;
    private boolean _has_pingInterval;
    private String _DALtype = "DAL";
    private int _serverThreads = 5;
    private boolean _has_serverThreads;
    private boolean _recovery = true;
    private boolean _has_recovery;
    private Array _autoload;
    private DeployInfo _deployInfo;
    private LoggingConfig _loggingConfig;

    public Container() {
        this.setDALtype("DAL");
    }

    public void deleteManagerRetry() {
        this._has_managerRetry = false;
    }

    public void deletePingInterval() {
        this._has_pingInterval = false;
    }

    public void deleteRecovery() {
        this._has_recovery = false;
    }

    public void deleteServerThreads() {
        this._has_serverThreads = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public void deleteUseIFR() {
        this._has_useIFR = false;
    }

    public Array getAutoload() {
        return this._autoload;
    }

    public String getDALtype() {
        return this._DALtype;
    }

    public DeployInfo getDeployInfo() {
        return this._deployInfo;
    }

    public ContainerImplLangType getImplLang() {
        return this._implLang;
    }

    public LoggingConfig getLoggingConfig() {
        return this._loggingConfig;
    }

    public int getManagerRetry() {
        return this._managerRetry;
    }

    public int getPingInterval() {
        return this._pingInterval;
    }

    public boolean getRecovery() {
        return this._recovery;
    }

    public int getServerThreads() {
        return this._serverThreads;
    }

    public double getTimeout() {
        return this._timeout;
    }

    public boolean getUseIFR() {
        return this._useIFR;
    }

    public boolean hasManagerRetry() {
        return this._has_managerRetry;
    }

    public boolean hasPingInterval() {
        return this._has_pingInterval;
    }

    public boolean hasRecovery() {
        return this._has_recovery;
    }

    public boolean hasServerThreads() {
        return this._has_serverThreads;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean hasUseIFR() {
        return this._has_useIFR;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void setAutoload(Array autoload) {
        this._autoload = autoload;
    }

    public void setDALtype(String DALtype) {
        this._DALtype = DALtype;
    }

    public void setDeployInfo(DeployInfo deployInfo) {
        this._deployInfo = deployInfo;
    }

    public void setImplLang(ContainerImplLangType implLang) {
        this._implLang = implLang;
    }

    public void setLoggingConfig(LoggingConfig loggingConfig) {
        this._loggingConfig = loggingConfig;
    }

    public void setManagerRetry(int managerRetry) {
        this._managerRetry = managerRetry;
        this._has_managerRetry = true;
    }

    public void setPingInterval(int pingInterval) {
        this._pingInterval = pingInterval;
        this._has_pingInterval = true;
    }

    public void setRecovery(boolean recovery) {
        this._recovery = recovery;
        this._has_recovery = true;
    }

    public void setServerThreads(int serverThreads) {
        this._serverThreads = serverThreads;
        this._has_serverThreads = true;
    }

    public void setTimeout(double timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public void setUseIFR(boolean useIFR) {
        this._useIFR = useIFR;
        this._has_useIFR = true;
    }

    public static Container unmarshalContainer(Reader reader) throws MarshalException, ValidationException {
        return (Container)Unmarshaller.unmarshal(Container.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

