/*
 * Decompiled with CFR 0.152.
 */
package alma.maci.loggingconfig;

import alma.maci.loggingconfig.NamedLogger;
import alma.maci.loggingconfig.UnnamedLogger;
import alma.maci.loggingconfig.types.LogLevel;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class LoggingConfig
extends UnnamedLogger
implements Serializable {
    private String _centralizedLogger = "Log";
    private int _dispatchPacketSize = 100;
    private boolean _has_dispatchPacketSize;
    private LogLevel _immediateDispatchLevel = LogLevel.valueOf("10");
    private int _flushPeriodSeconds = 10;
    private boolean _has_flushPeriodSeconds;
    private int _maxLogQueueSize = 1000;
    private boolean _has_maxLogQueueSize;
    private int _maxLogsPerSecond = -1;
    private boolean _has_maxLogsPerSecond;
    private ArrayList _List;

    public LoggingConfig() {
        this.setCentralizedLogger("Log");
        this.setImmediateDispatchLevel(LogLevel.valueOf("10"));
        this._List = new ArrayList();
    }

    public void add(NamedLogger v) throws IndexOutOfBoundsException {
        this._List.add(v);
    }

    public void add(int index, NamedLogger v) throws IndexOutOfBoundsException {
        this._List.add(index, v);
    }

    public void clear() {
        this._List.clear();
    }

    public void deleteDispatchPacketSize() {
        this._has_dispatchPacketSize = false;
    }

    public void deleteFlushPeriodSeconds() {
        this._has_flushPeriodSeconds = false;
    }

    public void deleteMaxLogQueueSize() {
        this._has_maxLogQueueSize = false;
    }

    public void deleteMaxLogsPerSecond() {
        this._has_maxLogsPerSecond = false;
    }

    public Enumeration enumerate() {
        return new IteratorEnumeration(this._List.iterator());
    }

    public NamedLogger get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._List.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (NamedLogger)this._List.get(index);
    }

    public NamedLogger[] get() {
        int size = this._List.size();
        NamedLogger[] mArray = new NamedLogger[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (NamedLogger)this._List.get(index);
        }
        return mArray;
    }

    public String getCentralizedLogger() {
        return this._centralizedLogger;
    }

    public int getCount() {
        return this._List.size();
    }

    public int getDispatchPacketSize() {
        return this._dispatchPacketSize;
    }

    public int getFlushPeriodSeconds() {
        return this._flushPeriodSeconds;
    }

    public LogLevel getImmediateDispatchLevel() {
        return this._immediateDispatchLevel;
    }

    public int getMaxLogQueueSize() {
        return this._maxLogQueueSize;
    }

    public int getMaxLogsPerSecond() {
        return this._maxLogsPerSecond;
    }

    public boolean hasDispatchPacketSize() {
        return this._has_dispatchPacketSize;
    }

    public boolean hasFlushPeriodSeconds() {
        return this._has_flushPeriodSeconds;
    }

    public boolean hasMaxLogQueueSize() {
        return this._has_maxLogQueueSize;
    }

    public boolean hasMaxLogsPerSecond() {
        return this._has_maxLogsPerSecond;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean remove(NamedLogger v) {
        boolean removed = this._List.remove(v);
        return removed;
    }

    public void set(int index, NamedLogger v) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._List.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._List.set(index, v);
    }

    public void set(NamedLogger[] Array2) {
        this._List.clear();
        for (int i = 0; i < Array2.length; ++i) {
            this._List.add(Array2[i]);
        }
    }

    public void setCentralizedLogger(String centralizedLogger) {
        this._centralizedLogger = centralizedLogger;
    }

    public void setDispatchPacketSize(int dispatchPacketSize) {
        this._dispatchPacketSize = dispatchPacketSize;
        this._has_dispatchPacketSize = true;
    }

    public void setFlushPeriodSeconds(int flushPeriodSeconds) {
        this._flushPeriodSeconds = flushPeriodSeconds;
        this._has_flushPeriodSeconds = true;
    }

    public void setImmediateDispatchLevel(LogLevel immediateDispatchLevel) {
        this._immediateDispatchLevel = immediateDispatchLevel;
    }

    public void setMaxLogQueueSize(int maxLogQueueSize) {
        this._maxLogQueueSize = maxLogQueueSize;
        this._has_maxLogQueueSize = true;
    }

    public void setMaxLogsPerSecond(int maxLogsPerSecond) {
        this._maxLogsPerSecond = maxLogsPerSecond;
        this._has_maxLogsPerSecond = true;
    }

    public static LoggingConfig unmarshalLoggingConfig(Reader reader) throws MarshalException, ValidationException {
        return (LoggingConfig)Unmarshaller.unmarshal(LoggingConfig.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

