/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection.filter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.OngoingInjecter;
import org.mockito.internal.util.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBasedCandidateFilter
implements MockCandidateFilter {
    private final MockCandidateFilter next;
    private final MockUtil mockUtil = new MockUtil();

    public NameBasedCandidateFilter(MockCandidateFilter next) {
        this.next = next;
    }

    @Override
    public OngoingInjecter filterCandidate(Collection<Object> mocks, Field field, Object fieldInstance) {
        ArrayList<Object> mockNameMatches = new ArrayList<Object>();
        if (mocks.size() > 1) {
            for (Object mock : mocks) {
                if (!field.getName().equals(((Object)this.mockUtil.getMockName(mock)).toString())) continue;
                mockNameMatches.add(mock);
            }
            return this.next.filterCandidate(mockNameMatches, field, fieldInstance);
        }
        return this.next.filterCandidate(mocks, field, fieldInstance);
    }
}

