/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.internal.util.Checks;
import org.mockito.internal.util.reflection.FieldReader;
import org.mockito.internal.util.reflection.FieldSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceField {
    private final Field field;
    private final Object instance;
    private FieldReader fieldReader;

    public InstanceField(Field field, Object instance) {
        this.field = Checks.checkNotNull(field, "field");
        this.instance = Checks.checkNotNull(instance, "instance");
    }

    public Object read() {
        return this.reader().read();
    }

    public void set(Object value) {
        new FieldSetter(this.instance, this.field).set(value);
    }

    public boolean isNull() {
        return this.reader().isNull();
    }

    public boolean isAnnotatedBy(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    public <A extends Annotation> A annotation(Class<A> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Field jdkField() {
        return this.field;
    }

    private FieldReader reader() {
        if (this.fieldReader == null) {
            this.fieldReader = new FieldReader(this.instance, this.field);
        }
        return this.fieldReader;
    }

    public String name() {
        return this.field.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceField that = (InstanceField)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.instance.equals(that.instance);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.instance.hashCode();
        return result;
    }
}

