/*
 * Decompiled with CFR 0.152.
 */
package diva.util.xml;

import diva.util.Filter;
import diva.util.FilteredIterator;
import diva.util.IteratorUtilities;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class XmlElement {
    private List _children = new ArrayList();
    private TreeMap _attributes;
    private String _type;
    private String _pcdata = "";
    private XmlElement _parent;

    public XmlElement(String type) {
        this._attributes = new TreeMap();
        this._type = type;
    }

    public XmlElement() {
        this("UNKNOWN");
    }

    public XmlElement(String type, Map attrs) {
        this._attributes = new TreeMap(attrs);
        this._type = type;
    }

    public void addElement(XmlElement e) {
        this._children.add(e);
        e.setParent(this);
    }

    public void appendPCData(String s) {
        this._pcdata = this._pcdata + s;
    }

    public Iterator attributeNames() {
        return this._attributes.keySet().iterator();
    }

    public boolean containsElement(XmlElement elt) {
        return this._children.contains(elt);
    }

    public int elementCount() {
        return this._children.size();
    }

    public Iterator elements() {
        return this._children.iterator();
    }

    public Iterator elements(final String type) {
        return new FilteredIterator(this.elements(), new Filter(){

            public boolean accept(Object o) {
                return ((XmlElement)o)._type.equals(type);
            }
        });
    }

    public String getAttribute(String name) {
        return (String)this._attributes.get(name);
    }

    public Map getAttributeMap() {
        return this._attributes;
    }

    public List getChildList() {
        return this._children;
    }

    public XmlElement getElement(final String type) {
        return (XmlElement)IteratorUtilities.firstMatch(this.elements(), new Filter(){

            public boolean accept(Object o) {
                return ((XmlElement)o)._type.equals(type);
            }
        });
    }

    public XmlElement getElement(final String type, final String name) {
        return (XmlElement)IteratorUtilities.firstMatch(this.elements(), new Filter(){

            public boolean accept(Object o) {
                XmlElement elt = (XmlElement)o;
                return elt._type.equals(type) && elt.getAttribute("name").equals(name);
            }
        });
    }

    public String getType() {
        return this._type;
    }

    public XmlElement getParent() {
        return this._parent;
    }

    public String getPCData() {
        return this._pcdata;
    }

    public boolean hasAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void removeElement(XmlElement e) {
        e.setParent(null);
        this._children.remove(e);
    }

    public void setAttribute(String name, String value) {
        this._attributes.put(name, value);
    }

    public void setParent(XmlElement p) {
        this._parent = p;
    }

    public void setPCData(String s) {
        this._pcdata = s;
    }

    public void setType(String s) {
        this._type = s;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeXML(sw, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sw.toString();
    }

    public void writeXML(Writer out, String prefix) throws IOException {
        out.write(prefix + "<" + this.getType());
        Iterator attrs = this.attributeNames();
        while (attrs.hasNext()) {
            String name = (String)attrs.next();
            String value = this.getAttribute(name);
            out.write(" " + name + "=\"" + value + "\"");
        }
        String pcdata = this.getPCData();
        if (this.elementCount() > 0 || pcdata.length() > 0) {
            out.write(">");
            if (this.elementCount() > 0) {
                Iterator children = this.elements();
                out.write("\n");
                while (children.hasNext()) {
                    XmlElement child = (XmlElement)children.next();
                    child.writeXML(out, prefix + "    ");
                }
                out.write(prefix);
            }
            if (pcdata.length() > 0) {
                out.write(pcdata);
            }
            out.write("</" + this.getType() + ">\n");
        } else {
            out.write("/>\n");
        }
    }
}

