<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:txfms="file:///home/ab/AlmaDev/XsltChain/ConvertZip"
                xmlns:alma="http://www.roe.ac.uk/ukatc/projects/alma/ConvertZip"
                xmlns:op="Alma/ObsPrep/ObsProject"
                xmlns:vt="Alma/ValueTypes">
                
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Import the "identity" stylesheet. This will ensure everything is copied to the output,  if 
     not directly addressed below. Still having problems with import. To be investigated.
     So for the moment still have this template in place explicitly. AB 20070720. 
<xsl:import href="alma:basic-copy.xslt"/> 
-->                

<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="@datamodelVersion">
   <xsl:attribute name="datamodelVersion">1.62</xsl:attribute>
   <xsl:comment>Converted to 1.62 by ObsProject30-40.xslt</xsl:comment>
</xsl:template>


<!-- Rename SingleFieldWizardParameters -->
<xsl:template match="op:SingleFieldWizardParameters">
<ScienceGoal>
   <xsl:apply-templates/>
</ScienceGoal>
</xsl:template>

<!-- Rename OpticalPointingWizardParameters -->
<xsl:template match="op:OpticalPointingWizardParameters">
<OpticalPointingScienceGoal>
   <xsl:apply-templates/>
</OpticalPointingScienceGoal>
</xsl:template>

<!-- Rename SingleFieldTargetParameters, and add the "type" of pattern: for this migration the only type  
     originally allowed was "single field", so all migrated projects will therefore have the 
     F_MultiplePoints  pattern -->
<xsl:template match="op:SingleFieldWizardParameters/op:SingleFieldTargetParameters">
<TargetParameters>
   <xsl:attribute name="type">F_MultiplePoints</xsl:attribute>
   <xsl:apply-templates/>
</TargetParameters>
</xsl:template>

<!-- Move pointingCenter info into SinglePoint. As origin must have been a single field offset, then
     make the type of coords "RELATIVE" if not found. Treat system in similar way -->
<xsl:template match="op:SingleFieldWizardParameters/op:SingleFieldTargetParameters/op:pointingCenter">
<SinglePoint>
   <name><xsl:value-of select="./vt:fieldName"/></name>
   <centre>
   <!-- Ensure system is set: it seems many programs don't have it set. -->
      <xsl:choose>
         <xsl:when test="@system">
            <xsl:attribute name="system"><xsl:value-of select="@system"/></xsl:attribute>
         </xsl:when>
         <xsl:otherwise>
            <xsl:attribute name="system">J2000</xsl:attribute>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
         <xsl:when test="@type">
            <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
         </xsl:when>
         <xsl:otherwise>
            <xsl:attribute name="type">RELATIVE</xsl:attribute>
         </xsl:otherwise>
      </xsl:choose>
   <!-- Copy lat/long. Why do I put both op and vt namespaces? Well, because if the project was created
        natively the namespace will be vt, if migrated by our xslt it looks like it will be op. Only one
        should be there, so we should be ok. Fingers crossed. -->
      <xsl:copy-of select="./op:longitude"/>
      <xsl:copy-of select="./op:latitude"/>
      <xsl:copy-of select="./vt:longitude"/>
      <xsl:copy-of select="./vt:latitude"/>
   </centre>
</SinglePoint>
</xsl:template>

<!-- Add ABSOLUTE to sourceCoordinates if it is not there... -->
<xsl:template match="op:sourceCoordinates">
<sourceCoordinates>
   <xsl:attribute name="system"><xsl:value-of select="@system"/></xsl:attribute>
   <xsl:choose>
   <xsl:when test="@type">
      <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
         </xsl:when>
   <xsl:otherwise>
      <xsl:attribute name="type">ABSOLUTE</xsl:attribute>
   </xsl:otherwise>
   </xsl:choose>
   <xsl:copy-of select="node()"/>
</sourceCoordinates>
</xsl:template>


<!-- Rename SingleFieldControlParameters -->
<xsl:template match="op:SingleFieldWizardParameters/op:SingleFieldControlParameters"> 
<PerformanceParameters>
   <xsl:apply-templates/>
</PerformanceParameters>
</xsl:template>

</xsl:stylesheet>