#! /bin/bash
#
# This installer creates various launcher-scripts for running from the commandline.
# msc 2005-11-18
#

if [ `dirname $0` != "." ] ; then
   echo "Please run this script from the setup directory"
   exit 1;
fi


# locate java and check java version (msc 2015-02, ICT-4570)
# -----------------------------------------------------------

## note: with Java 1.6, the java executable supports a cli option to enforce
## a certain version. this option performs automagic discovery of additional
## java installations, and will autonomously pick one. useful, but obscure.
## also, the option will produce an error when used on a 1.5 java executable.


function java_release {
   local jexecutable=$1
   local jversion=`$jexecutable -version 2>&1 | grep "java version" | tr -d \" | awk '{print $3}' ` 
   local jrelease=`echo $jversion | awk '{split($1,res,"."); print res[2]}' `
   echo $jrelease
}

# this runs the connection check, but only for learning if the jvm
# on this host is tool old for our byte code (msc 2015-10, ICT-5924)
function java_version_probe {
   java -cp . ConnectionCheck 2>&1 1>/dev/null | grep java.lang.UnsupportedClassVersionError
}


javacmd=
if [ -e ../jre/bin/java ] ; then 

   # no need for further checks if this OT is bundled with a JRE
   javacmd=../jre/bin/java

else
   echo -en "\nVerifying that you have an acceptable version of Java installed... "

   JavaFound=`which java 2>/dev/null`
   if [ ! "$JavaFound" ] ; then
      echo "failed"
      echo "Problem: Could not locate any \"java\" executable in your \$PATH. Is Java installed?"
      echo " Please install a recent version of Java (http://java.com), or correct your \$PATH."
      exit 1;
   fi

   JavaTooOld=`java_version_probe`
   if [ "$JavaTooOld" ] ; then
      echo "failed"
      echo "Problem: The \"java\" executable in your \$PATH (at $JavaFound) is too old: Java `java_release java`"
      echo " Please install a more recent version of Java (http://java.com), or correct your \$PATH."
      exit 1;
   fi

   echo "ok"

   OpenJdk=`java -version 2>&1 | grep "OpenJDK" `
   if [ "$OpenJdk" ] ; then
      echo "Note: You are using an OpenJDK variant of Java, but Oracle variants (http://java.com) are recommended for the OT."
   fi

   javacmd=java
fi




# help users configure their proxy settings (msc 2014-12, ICT-3035)
# ------------------------------------------------------------------

function ask { # interactive prompt with default reply
   local question=$1 ; local default=$2
   read -p "${question/\{\}/$default}"
   if [ -z "$REPLY" ] ; then REPLY=$default; fi
}

function connection_check { # run a java program that connects to the web
   local protocol=$1
   echo -en "\nProbing your $protocol internet connection... "
   $javacmd $proxysettings -cp . ConnectionCheck  $protocol://www.wikipedia.org/  7000
   if [ $? == 5 ]
   	then connection_check_failed=true ; echo "failed"
   	else connection_check_failed=     ; echo "ok"
   fi
}

proxysettings=""
connection_check https

if [ $connection_check_failed ] ; then
   ask "Are you (a) simply just offline, or are you (b) behind a proxy server [{}]? " b
   if [ $REPLY == b ] ; then

   	proxysettings="-Djava.net.useSystemProxies=true"
   	connection_check https

   	if [ $connection_check_failed ] ; then
      	echo "Your operating system does not support automatic discovery of proxy server"
      	echo "settings. Please enter them manually."

      	while [ $connection_check_failed ] ; do
      		ask "HTTPS Proxy Host: "           ; httpsHost=$REPLY
      		ask "HTTPS Proxy Port [{}]: " 443  ; httpsPort=$REPLY
      		proxysettings="-Dhttps.proxyHost=$httpsHost -Dhttps.proxyPort=$httpsPort"
      		connection_check https
      	done

			while [ $connection_check_failed ] ; do
      		ask "HTTP Proxy Host [same as for HTTPS]: " $httpsHost ; httpHost=$REPLY
      		ask "HTTP Proxy Port [{}]: "                8080       ; httpPort=$REPLY
      		proxysettings="$proxysettings -Dhttp.proxyHost=$httpHost -Dhttp.proxyPort=$httpPort"
      		connection_check http
      	done
      fi
   fi
fi



# create the launcher scripts
# -------------------------------------------------------------

cd ..
installdir=$PWD

echo ""
echo "Your install dir is $installdir"

# inserts the cwd into the launcher-scripts
function create {
   local create=$1
   local template=setup/$3

   {
    echo "#! /bin/bash"
    echo "INSTALLDIR=$installdir"
    echo "PROXYSETTINGS=$proxysettings"
    cat $template
   } > $create

   chmod 775 $create
   echo "  created $create"
}

# create launcher-scripts
echo "Creating scripts in install dir:"
create ALMA-OT.sh from ALMA-OT.sh.tpl

