#!/usr/bin/env python
#*******************************************************************************
# ALMA - Atacama Large Millimeter Array
# Copyright (c) ESO - European Southern Observatory, 2011
# (in the framework of the ALMA collaboration).
# All rights reserved.
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#*******************************************************************************
import sys
import getopt
# import CCL.SSRSetup
from Acspy.Util.XmlObjectifier import XmlObject
from CCL.schedblock import SB

"""This is a utility to run observation scripts without having ACS running.

It allows to pass the name of a module where simulation mocks are defined as
an option.
Also, the name of an XML file where a scheduling block is defined can be passed
as an option.
"""

def help():
    print """
SYNTAX

  observe.py <OPTIONS> <observing-script>
   
OPTIONS
  --schedblock=<Scheduling Block XML File Name>
  --simmod=<Simulation Module Name>
"""

shortopts = '' # No short options
longopts = ['schedblock=', 'simmod=']
optlist, args = getopt.getopt(sys.argv[1:], shortopts, longopts)

optkeyw = map(lambda t: t[0], optlist)

if len(args) < 1:
    print "ERROR: No observing script provided. The name of observing script to\
 run must be passed as argument."
    help()
    sys.exit(-1)

obs_script = args[0]

if '--schedblock' in optkeyw:
    schedblockFileName = filter(lambda t: t[0] == '--schedblock', optlist)[0][1]
    f = open(schedblockFileName)
    xml = f.read()
    f.close()
    sb = SB(XmlObject(xmlString=xml))
    def getSB():
        return sb
    import CCL.Global
    CCL.Global.getSB = getSB

if '--simmod' in optkeyw:
    simModuleName = filter(lambda t: t[0] == '--simmod', optlist)[0][1]
    simModule = __import__(simModuleName, globals(), locals(), ['*'])

# Run the observation script
execfile(obs_script)

# __oOo__
