/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.ValueInfo;

public class TextTableWriter
extends StreamStarTableWriter {
    private boolean writeParams = true;
    private static final Logger logger_;
    static /* synthetic */ Class class$java$lang$String;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getFormatName() {
        return "text";
    }

    public String getMimeType() {
        return "text/plain";
    }

    public boolean looksLikeFile(String location) {
        return location.equals("-") || location.endsWith(".txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable startab, OutputStream strm) throws IOException {
        RowSequence rseq = startab.getRowSequence();
        try {
            this.writeStarTable(startab, rseq, strm);
        }
        finally {
            rseq.close();
        }
    }

    private void writeStarTable(StarTable startab, RowSequence rseq, OutputStream strm) throws IOException {
        Iterator it;
        Object[] row;
        ArrayList<Object[]> sampleList = new ArrayList<Object[]>();
        boolean allRowsSampled = false;
        int maxSamples = this.getSampledRows();
        logger_.config("Reading <=" + maxSamples + " rows to guess column widths");
        for (int ir = 0; ir < maxSamples; ++ir) {
            if (!rseq.next()) {
                allRowsSampled = true;
                break;
            }
            sampleList.add(rseq.getRow());
        }
        logger_.config(sampleList.size() + (allRowsSampled ? " (all)" : "") + " rows read to guess column widths");
        int ncol = startab.getColumnCount();
        ColumnInfo[] cinfos = new ColumnInfo[ncol];
        int[] cwidths = new int[ncol];
        int[] maxWidths = new int[ncol];
        for (int i = 0; i < ncol; ++i) {
            cinfos[i] = startab.getColumnInfo(i);
            cwidths[i] = cinfos[i].getName().length();
            maxWidths[i] = this.getMaxWidth(cinfos[i].getContentClass());
        }
        Iterator it2 = sampleList.iterator();
        while (it2.hasNext()) {
            row = (Object[])it2.next();
            for (int i = 0; i < ncol; ++i) {
                String formatted = cinfos[i].formatValue(row[i], maxWidths[i]);
                if (formatted.length() <= cwidths[i]) continue;
                cwidths[i] = formatted.length();
            }
        }
        if (!allRowsSampled) {
            for (int icol = 0; icol < ncol; ++icol) {
                int nchar;
                int n = icol;
                cwidths[n] = cwidths[n] + 2;
                ColumnInfo cinfo = cinfos[icol];
                if (!cinfo.getContentClass().equals(class$java$lang$String == null ? TextTableWriter.class$("java.lang.String") : class$java$lang$String) || (nchar = cinfo.getElementSize()) <= 0) continue;
                cwidths[icol] = nchar;
            }
        }
        for (int i = 0; i < ncol; ++i) {
            cwidths[i] = Math.min(maxWidths[i], cwidths[i]);
        }
        if (this.writeParams) {
            String name = startab.getName();
            if (name != null && name.trim().length() > 0) {
                this.printParam(strm, "Table name", name);
            }
            it = startab.getParameters().iterator();
            while (it.hasNext()) {
                DescribedValue param = (DescribedValue)it.next();
                this.printParam(strm, param.getInfo().getName(), param.getValueAsString(160));
            }
        }
        this.printColumnHeads(strm, cwidths, cinfos);
        String[] data = new String[ncol];
        it = sampleList.iterator();
        while (it.hasNext()) {
            Object[] row2 = (Object[])it.next();
            for (int icol = 0; icol < ncol; ++icol) {
                data[icol] = this.formatValue(row2[icol], cinfos[icol], cwidths[icol]);
            }
            this.printLine(strm, cwidths, data);
        }
        if (!allRowsSampled) {
            logger_.config("Streaming remaining data rows");
        } else if (!$assertionsDisabled && rseq.next()) {
            throw new AssertionError();
        }
        while (rseq.next()) {
            row = rseq.getRow();
            for (int icol = 0; icol < ncol; ++icol) {
                data[icol] = this.formatValue(row[icol], cinfos[icol], cwidths[icol]);
            }
            this.printLine(strm, cwidths, data);
        }
        this.printSeparator(strm, cwidths);
    }

    public void setWriteParameters(boolean writeParams) {
        this.writeParams = writeParams;
    }

    public boolean getWriteParameters() {
        return this.writeParams;
    }

    public int getMaxWidth() {
        return 40;
    }

    public int getSampledRows() {
        return 200;
    }

    protected String formatValue(Object val, ValueInfo vinfo, int width) {
        return vinfo.formatValue(val, width);
    }

    protected void printSeparator(OutputStream strm, int[] colwidths) throws IOException {
        for (int i = 0; i < colwidths.length; ++i) {
            strm.write(43);
            strm.write(45);
            for (int j = 0; j < colwidths[i]; ++j) {
                strm.write(45);
            }
            strm.write(45);
        }
        strm.write(43);
        strm.write(10);
    }

    protected void printColumnHeads(OutputStream strm, int[] colwidths, ColumnInfo[] cinfos) throws IOException {
        int ncol = cinfos.length;
        String[] heads = new String[ncol];
        for (int i = 0; i < ncol; ++i) {
            heads[i] = cinfos[i].getName();
        }
        this.printSeparator(strm, colwidths);
        this.printLine(strm, colwidths, heads);
        this.printSeparator(strm, colwidths);
    }

    protected void printLine(OutputStream strm, int[] colwidths, String[] data) throws IOException {
        for (int i = 0; i < colwidths.length; ++i) {
            strm.write(124);
            strm.write(32);
            String datum = data[i] == null ? "" : data[i];
            int padding = colwidths[i] - datum.length();
            strm.write(TextTableWriter.getBytes(datum), 0, Math.min(colwidths[i], datum.length()));
            if (padding > 0) {
                for (int j = 0; j < padding; ++j) {
                    strm.write(32);
                }
            }
            strm.write(32);
        }
        strm.write(124);
        strm.write(10);
    }

    protected void printParam(OutputStream strm, String name, String value) throws IOException {
        strm.write(TextTableWriter.getBytes(name));
        strm.write(58);
        strm.write(32);
        strm.write(TextTableWriter.getBytes(value));
        strm.write(10);
    }

    protected static byte[] getBytes(String str) {
        int leng = str.length();
        byte[] buf = new byte[leng];
        for (int i = 0; i < leng; ++i) {
            buf[i] = (byte)str.charAt(i);
        }
        return buf;
    }

    private int getMaxWidth(Class clazz) {
        if (clazz == Double.class) {
            return Math.max(Double.toString(-1.7976931348623157E308).length(), Double.toString(-4.9E-324).length());
        }
        if (clazz == Float.class) {
            return Math.max(Float.toString(-3.4028235E38f).length(), Float.toString(-1.4E-45f).length());
        }
        if (clazz == Long.class) {
            return Math.max(Long.toString(Long.MIN_VALUE).length(), Long.toString(Long.MAX_VALUE).length());
        }
        if (clazz == Integer.class) {
            return Math.max(Integer.toString(Integer.MIN_VALUE).length(), Integer.toString(Integer.MAX_VALUE).length());
        }
        if (clazz == Short.class || clazz == Byte.class || clazz == Character.class) {
            return Math.max(Short.toString((short)Short.MIN_VALUE).length(), Short.toString((short)Short.MAX_VALUE).length());
        }
        return this.getMaxWidth();
    }

    static {
        $assertionsDisabled = !TextTableWriter.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.table.formats");
    }
}

