/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.NioDataAccess;

class MappedColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final int itemSize_;
    private final NioDataAccess access_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MappedColumnStore(Codec codec, ByteBuffer bbuf) {
        this.codec_ = codec;
        this.itemSize_ = codec.getItemSize();
        this.access_ = new NioDataAccess(bbuf);
        if (this.itemSize_ < 0) {
            throw new IllegalArgumentException("Must have fixed size codec");
        }
    }

    public void acceptCell(Object value) throws IOException {
        int nbyte = this.codec_.encode(value, this.access_);
        if (!$assertionsDisabled && nbyte != this.itemSize_) {
            throw new AssertionError();
        }
    }

    public void endCells() {
    }

    public synchronized Object readCell(long lrow) throws IOException {
        this.access_.seek(lrow * (long)this.itemSize_);
        return this.codec_.decode(this.access_);
    }

    public void dispose() {
    }

    static {
        $assertionsDisabled = !MappedColumnStore.class.desiredAssertionStatus();
    }
}

