/*
 * Decompiled with CFR 0.152.
 */
package alma.correlatorSrc.CorrConfigValidator;

import alma.correlatorSrc.CorrConfigValidator.LSInputImpl;
import alma.correlatorSrc.CorrConfigValidator.ResourceResolver;
import alma.correlatorSrc.CorrConfigValidator.jaxb.SchedBlock;
import alma.correlatorSrc.CorrConfigValidator.jaxb.SpectralSpecT;
import alma.entity.xmlbinding.schedblock.ACABaseBandConfigT;
import alma.entity.xmlbinding.schedblock.ACACorrelatorConfigurationT;
import alma.entity.xmlbinding.schedblock.ACASpectralWindowT;
import alma.entity.xmlbinding.schedblock.AbstractSpectralWindowT;
import alma.entity.xmlbinding.schedblock.BLSpectralWindowT;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLUnmarshaller {
    static final Logger logger = Logger.getLogger(XMLUnmarshaller.class.getName());
    protected static final JAXBContext JC;
    protected static final Schema SCHEMA;
    static final Charset UTF_8;
    static final String SCHEMA_PREFIX = "/schemas/";
    static final String[] SCHEMAS;
    static final String[] NAMESPACE_URIs;
    static final Pattern SW_NUMBER_PATTERN;

    static Source[] schemaSources() throws IOException {
        Source[] sources = new Source[SCHEMAS.length];
        for (int i = 0; i < SCHEMAS.length; ++i) {
            sources[i] = new StreamSource(XMLUnmarshaller.class.getResourceAsStream(SCHEMAS[i]), NAMESPACE_URIs[i]);
        }
        return sources;
    }

    protected static SpectralSpecT unmarshalSpectralSpec(InputStream is) throws JAXBException, UnmarshalException {
        Unmarshaller u = JC.createUnmarshaller();
        u.setSchema(SCHEMA);
        ValidationEventCollector collector = new ValidationEventCollector();
        u.setEventHandler((ValidationEventHandler)collector);
        SpectralSpecT o = null;
        try {
            JAXBElement elem = u.unmarshal((Source)new StreamSource(is), SpectralSpecT.class);
            o = (SpectralSpecT)elem.getValue();
        }
        catch (JAXBException e) {
            throw new UnmarshalException(collector.getEvents());
        }
        if (o == null) {
            throw new UnmarshalException(collector.getEvents());
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String spectralSpec2XML(SpectralSpecT ss) throws JAXBException, IOException {
        Marshaller m = JC.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)UTF_8.name());
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            JAXBElement elem = new JAXBElement(new QName("Alma/ObsPrep/SchedBlock", "SpectralSpec", "sbl"), SpectralSpecT.class, SchedBlock.class, (Object)ss);
            m.marshal((Object)elem, (OutputStream)os);
        }
        return new String(os.toByteArray(), UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SpectralSpecT unmarshalSpectralSpecFromString(String xml) throws JAXBException, IOException, UnmarshalException {
        byte[] bytes = xml.getBytes(UTF_8);
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            SpectralSpecT spectralSpecT = XMLUnmarshaller.unmarshalSpectralSpec(is);
            return spectralSpecT;
        }
    }

    protected static int swNumberFromSwName(String swName) {
        assert (swName != null);
        Matcher m = SW_NUMBER_PATTERN.matcher(swName);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid spectral window name form");
        }
        return Integer.parseInt(m.group(2));
    }

    private static <T extends AbstractSpectralWindowT> T[] sortSpectralWindowsHelper(T[] sws) {
        HashMap<String, String> assoc = new HashMap<String, String>();
        for (T s : sws) {
            if (s.getAssociatedSpectralWindowNumberInPair() == 0 || s.getAssociatedSpectralWindowNumberInPair() < 0 || s.getAssociatedSpectralWindowNumberInPair() > sws.length) continue;
            assoc.put(s.getName(), sws[s.getAssociatedSpectralWindowNumberInPair() - 1].getName());
        }
        Arrays.sort(sws, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return XMLUnmarshaller.swNumberFromSwName(a.getName()) - XMLUnmarshaller.swNumberFromSwName(b.getName());
            }
        });
        for (T s : sws) {
            if (!assoc.containsKey(s.getName())) continue;
            for (int i = 0; i < sws.length; ++i) {
                if (!assoc.get(s.getName()).equals(sws[i].getName())) continue;
                s.setAssociatedSpectralWindowNumberInPair(i + 1);
            }
        }
        return sws;
    }

    protected static void sortSpectralWindows(alma.entity.xmlbinding.schedblock.SpectralSpecT spectralSpec) {
        ACASpectralWindowT[] sws;
        assert (spectralSpec != null);
        ACACorrelatorConfigurationT corrConf = spectralSpec.getSpectralSpecTChoice().getACACorrelatorConfiguration();
        if (corrConf != null) {
            for (ACABaseBandConfigT aCABaseBandConfigT : corrConf.getACABaseBandConfig()) {
                sws = aCABaseBandConfigT.getACASpectralWindow();
                XMLUnmarshaller.sortSpectralWindowsHelper((AbstractSpectralWindowT[])sws);
                aCABaseBandConfigT.setACASpectralWindow(sws);
            }
        }
        if ((corrConf = spectralSpec.getSpectralSpecTChoice().getBLCorrelatorConfiguration()) != null) {
            for (ACABaseBandConfigT aCABaseBandConfigT : corrConf.getBLBaseBandConfig()) {
                sws = aCABaseBandConfigT.getBLSpectralWindow();
                XMLUnmarshaller.sortSpectralWindowsHelper((AbstractSpectralWindowT[])sws);
                aCABaseBandConfigT.setBLSpectralWindow((BLSpectralWindowT[])sws);
            }
        }
    }

    public static alma.entity.xmlbinding.schedblock.SpectralSpecT xml2SpectralSpecEntity(String spectralSpecXML) throws MarshalException, ValidationException {
        try {
            XMLUnmarshaller.unmarshalSpectralSpecFromString(spectralSpecXML);
        }
        catch (JAXBException e) {
            logger.log(Level.SEVERE, "Failed to validate XML.", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to validate XML.", e);
        }
        catch (UnmarshalException e) {
            logger.log(Level.SEVERE, "Failed to validate XML.", e);
        }
        return XMLUnmarshaller.xml2SpectralSpecEntityWithoutStrictValidation(spectralSpecXML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static alma.entity.xmlbinding.schedblock.SpectralSpecT xml2SpectralSpecEntityWithoutStrictValidation(String spectralSpecXML) throws MarshalException, ValidationException {
        try (StringReader sr = new StringReader(spectralSpecXML);){
            alma.entity.xmlbinding.schedblock.SpectralSpecT result = alma.entity.xmlbinding.schedblock.SpectralSpecT.unmarshalSpectralSpecT((Reader)sr);
            if (result != null) {
                result.validate();
                XMLUnmarshaller.sortSpectralWindows(result);
            }
            alma.entity.xmlbinding.schedblock.SpectralSpecT spectralSpecT = result;
            return spectralSpecT;
        }
    }

    static {
        UTF_8 = Charset.forName("UTF-8");
        SCHEMAS = new String[]{"/schemas/ValueTypes.xsd", "/schemas/CommonEntity.xsd", "/schemas/ObsAttachment.xsd", "/schemas/ObsProject.xsd", "/schemas/ObsProposal.xsd", "/schemas/ObsReview.xsd", "/schemas/OUSStatus.xsd", "/schemas/ProjectStatus.xsd", "/schemas/SBStatus.xsd", "/schemas/SchedBlock.xsd"};
        NAMESPACE_URIs = new String[]{"Alma/ValueTypes", "Alma/CommonEntity", "Alma/Obsprep/ObsAttachment", "Alma/ObsPrep/ObsProject", "Alma/ObsPrep/ObsProposal", "Alma/ObsPrep/ObsReview", "Alma/Scheduling/OUSStatus", "Alma/Scheduling/ProjectStatus", "Alma/Scheduling/SBStatus", "Alma/ObsPrep/SchedBlock"};
        assert (SCHEMAS.length == NAMESPACE_URIs.length);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String featureKey = "http://apache.org/xml/features/continue-after-fatal-error";
        try {
            sf.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
        }
        catch (SAXNotRecognizedException e) {
            logger.log(Level.WARNING, "http://apache.org/xml/features/continue-after-fatal-error is not supported.", e);
        }
        catch (SAXNotSupportedException e) {
            logger.log(Level.WARNING, "http://apache.org/xml/features/continue-after-fatal-error is not supported.", e);
        }
        ResourceResolver resolver = new ResourceResolver();
        LSInputImpl root = resolver.resolveResource_("http://www.w3.org/2001/XMLSchema", "Alma/ObsPrep/SchedBlock", null, "SchedBlock.xsd", "file:///");
        sf.setResourceResolver(resolver);
        Schema s = null;
        try {
            s = sf.newSchema(root.getStreamSource());
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Fatal error", e);
        }
        SCHEMA = s;
        JAXBContext ctx = null;
        try {
            ctx = JAXBContext.newInstance((String)"alma.correlatorSrc.CorrConfigValidator.jaxb");
        }
        catch (JAXBException e) {
            logger.log(Level.SEVERE, "Fatal error", e);
        }
        JC = ctx;
        SW_NUMBER_PATTERN = Pattern.compile("(^|.*[^0-9])([0-9]{1,2})$");
    }

    public static class UnmarshalException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final ValidationEvent[] events;

        @Override
        public String getMessage() {
            String msg = super.getMessage();
            if (msg == null) {
                msg = "";
            }
            StringBuilder sb = new StringBuilder(msg);
            String sep = "";
            for (ValidationEvent e : this.events) {
                sb.append(e.getMessage() + sep);
                sep = "\n";
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            return this.getMessage();
        }

        public UnmarshalException(Throwable t) {
            super(t);
            this.events = new ValidationEvent[0];
        }

        public UnmarshalException(Throwable t, ValidationEvent[] events) {
            super(t);
            this.events = events;
        }

        public UnmarshalException(ValidationEvent[] events) {
            this.events = events;
        }

        public ValidationEvent[] getEvents() {
            return this.events;
        }
    }
}

