/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.app.CommandCenterLogic;
import alma.acs.commandcenter.util.PreparedString;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

class EditCommandsPanel
extends JPanel
implements ActionListener {
    protected EditCommandsPanel(CommandCenterLogic controller) {
        this.setLayout(new GridLayout(0, 1));
        this.process(controller.executeServices);
        this.process(controller.executeManager);
        this.process(controller.executeContainer);
        this.process(controller.executeAcs);
        this.process(controller.executeTools);
        JButton btnSave = new JButton("Store values !");
        btnSave.addActionListener(this);
        btnSave.setBorder(new BevelBorder(0));
        this.add(new JPanel());
        this.add(btnSave);
        btnSave.setName("btn_Save");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof FieldStripe)) continue;
            FieldStripe s = null;
            try {
                s = (FieldStripe)this.getComponent(i);
                this.setFieldValue(s);
                continue;
            }
            catch (Exception e) {
                if (s != null) {
                    System.err.println("can't set field " + s.field + " to value " + s.valueF.getText() + ": " + e);
                    continue;
                }
                System.err.println("skipping field #" + i + ": it is null");
            }
        }
    }

    protected void process(Object obj) {
        Field[] f = obj.getClass().getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            Field field = f[i];
            if (!this.isInterestingField(field)) continue;
            try {
                this.add(new FieldStripe(obj, field));
                continue;
            }
            catch (Exception e) {
                System.err.println("can't read field: " + e);
            }
        }
    }

    protected boolean isInterestingField(Field f) {
        return f.getType().isAssignableFrom(PreparedString.class);
    }

    protected void setFieldValue(FieldStripe s) throws Exception {
        s.field.set(s.object, new PreparedString(s.valueF.getText()));
    }

    protected class FieldStripe
    extends JPanel {
        Object object;
        Field field;
        JTextField valueF;

        FieldStripe(Object o, Field f) throws Exception {
            this.object = o;
            this.field = f;
            this.setLayout(new GridLayout(1, 2));
            String cn = o.getClass().getName();
            this.add(new JLabel(cn.substring(cn.lastIndexOf(".") + 1) + "." + this.field.getName()));
            this.valueF = new JTextField(30);
            this.add(this.valueF);
            this.valueF.setText(String.valueOf(this.field.get(this.object)));
        }
    }
}

