/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.meta;

import alma.acs.component.client.AdvancedComponentClient;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.AcsLocations;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;

public class Firestarter {
    protected String clientName;
    protected AcsLogger logger = null;
    protected AdvancedComponentClient advancedComponentClient = null;
    protected String managerLoc = null;
    protected AcsCorba acsCorba = null;
    protected Integer orbPort = null;
    protected Integer orbPortSearchRetry = null;

    protected Firestarter(String clientName) {
        this(clientName, null, null);
    }

    public Firestarter(String clientName, AcsLogger logger, String managerLoc) {
        if (clientName == null) {
            throw new NullPointerException("clientName should not be null");
        }
        this.clientName = clientName;
        if (logger == null) {
            logger = ClientLogManager.getAcsLogManager().getLoggerForApplication(clientName + ".Firestarter", false);
        }
        this.logger = logger;
        if (managerLoc == null) {
            managerLoc = AcsLocations.figureOutManagerLocation();
        }
        this.managerLoc = managerLoc;
    }

    public void shutdown() {
        try {
            if (this.advancedComponentClient != null) {
                this.advancedComponentClient.tearDown();
                this.advancedComponentClient = null;
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, "failed to stop AdvancedComponentClient", t);
        }
        try {
            if (this.acsCorba != null) {
                new Thread(){

                    @Override
                    public void run() {
                        boolean wait_for_completion = true;
                        boolean isOrbThread = false;
                        Firestarter.this.acsCorba.shutdownORB(wait_for_completion, isOrbThread);
                        Firestarter.this.acsCorba = null;
                    }
                }.start();
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, "failed to stop AcsCorba", t);
        }
    }

    public AdvancedComponentClient giveAdvancedComponentClient() throws Exception {
        if (this.advancedComponentClient == null) {
            this.giveAcsCorba();
            this.advancedComponentClient = new AdvancedComponentClient((Logger)this.logger, this.managerLoc, this.clientName + ".ComponentClient", this.acsCorba);
        }
        return this.advancedComponentClient;
    }

    public ORB giveOrb() throws OrbInitException {
        this.giveAcsCorba();
        return this.acsCorba.getORB();
    }

    public AcsCorba giveAcsCorba() throws OrbInitException {
        if (this.acsCorba == null) {
            this.acsCorba = new AcsCorba(this.logger);
            this.acsCorba.setPortOptions(this.orbPort, this.orbPortSearchRetry);
        }
        if (!this.acsCorba.isInitialized()) {
            try {
                boolean isAdmin = true;
                this.acsCorba.initCorbaForClient(isAdmin);
            }
            catch (Exception exc) {
                throw new OrbInitException("acsCorba.initCorbaForClient(true) failed", exc);
            }
        }
        return this.acsCorba;
    }

    public static class OrbInitException
    extends Exception {
        OrbInitException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

