/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.adapters;

import alma.acs.logging.AcsLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLogger
extends Logger {
    private final AcsLogger delegate;

    public Log4jLogger(String name, AcsLogger delegate) {
        super(name);
        this.delegate = delegate;
        delegate.addLoggerClass(Log4jLogger.class);
    }

    public boolean isTraceEnabled() {
        return this.delegate.isLoggable(this.log4jLevelToJdkLevel((Priority)Level.TRACE));
    }

    public boolean isDebugEnabled() {
        return this.delegate.isLoggable(this.log4jLevelToJdkLevel((Priority)Level.DEBUG));
    }

    public boolean isInfoEnabled() {
        return this.delegate.isLoggable(this.log4jLevelToJdkLevel((Priority)Level.INFO));
    }

    protected void forcedLog(String fqcn, Priority level, Object message, Throwable t) {
        this.delegate.log(this.log4jLevelToJdkLevel(level), message.toString(), t);
    }

    java.util.logging.Level log4jLevelToJdkLevel(Priority level) {
        switch (level.toInt()) {
            case 5000: {
                return java.util.logging.Level.FINEST;
            }
            case 10000: {
                return java.util.logging.Level.FINER;
            }
            case 20000: {
                return java.util.logging.Level.INFO;
            }
            case 50000: {
                return java.util.logging.Level.SEVERE;
            }
        }
        return java.util.logging.Level.WARNING;
    }
}

