/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodProxy;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.creation.DelegatingMockitoMethodProxy;
import org.mockito.internal.creation.MockitoMethodProxy;
import org.mockito.internal.creation.SerializableMockitoMethodProxy;
import org.mockito.internal.creation.cglib.CGLIBHacker;
import org.mockito.internal.invocation.InvocationImpl;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.invocation.realmethod.FilteredCGLIBProxyRealMethod;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;

public class MethodInterceptorFilter
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 6182795666612683784L;
    private final InternalMockHandler handler;
    CGLIBHacker cglibHacker = new CGLIBHacker();
    ObjectMethodsGuru objectMethodsGuru = new ObjectMethodsGuru();
    private final MockCreationSettings mockSettings;

    public MethodInterceptorFilter(InternalMockHandler handler, MockCreationSettings mockSettings) {
        this.handler = handler;
        this.mockSettings = mockSettings;
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (this.objectMethodsGuru.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (this.objectMethodsGuru.isHashCodeMethod(method)) {
            return this.hashCodeForMock(proxy);
        }
        MockitoMethodProxy mockitoMethodProxy = this.createMockitoMethodProxy(methodProxy);
        this.cglibHacker.setMockitoNamingPolicy(mockitoMethodProxy);
        MockitoMethod mockitoMethod = this.createMockitoMethod(method);
        FilteredCGLIBProxyRealMethod realMethod = new FilteredCGLIBProxyRealMethod(mockitoMethodProxy);
        InvocationImpl invocation = new InvocationImpl(proxy, mockitoMethod, args, SequenceNumber.next(), realMethod);
        return this.handler.handle(invocation);
    }

    public MockHandler getHandler() {
        return this.handler;
    }

    private int hashCodeForMock(Object mock) {
        return System.identityHashCode(mock);
    }

    public MockitoMethodProxy createMockitoMethodProxy(MethodProxy methodProxy) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMockitoMethodProxy(methodProxy);
        }
        return new DelegatingMockitoMethodProxy(methodProxy);
    }

    public MockitoMethod createMockitoMethod(Method method) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMethod(method);
        }
        return new DelegatingMethod(method);
    }
}

