/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.exceptions.VerificationAwareInvocation;
import org.mockito.internal.invocation.ArgumentsProcessor;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.StubInfo;

public class InvocationImpl
implements Invocation,
VerificationAwareInvocation {
    private static final long serialVersionUID = 8240069639250980199L;
    private final int sequenceNumber;
    private final Object mock;
    private final MockitoMethod method;
    private final Object[] arguments;
    private final Object[] rawArguments;
    private final Location location;
    private boolean verified;
    private boolean isIgnoredForVerification;
    final RealMethod realMethod;
    private StubInfo stubInfo;

    public InvocationImpl(Object mock, MockitoMethod mockitoMethod, Object[] args, int sequenceNumber, RealMethod realMethod) {
        this.method = mockitoMethod;
        this.mock = mock;
        this.realMethod = realMethod;
        this.arguments = ArgumentsProcessor.expandVarArgs(mockitoMethod.isVarArgs(), args);
        this.rawArguments = args;
        this.sequenceNumber = sequenceNumber;
        this.location = new LocationImpl();
    }

    public Object getMock() {
        return this.mock;
    }

    public Method getMethod() {
        return this.method.getJavaMethod();
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public boolean isVerified() {
        return this.verified || this.isIgnoredForVerification;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        InvocationImpl other = (InvocationImpl)o;
        return this.mock.equals(other.mock) && this.method.equals(other.method) && this.equalArguments(other.arguments);
    }

    private boolean equalArguments(Object[] arguments) {
        return Arrays.equals(arguments, this.arguments);
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return new PrintSettings().print(ArgumentsProcessor.argumentsToMatchers(this.getArguments()), this);
    }

    public Location getLocation() {
        return this.location;
    }

    public Object[] getRawArguments() {
        return this.rawArguments;
    }

    public Object callRealMethod() throws Throwable {
        if (this.getMethod().getDeclaringClass().isInterface()) {
            new Reporter().cannotCallRealMethodOnInterface();
        }
        return this.realMethod.invoke(this.mock, this.rawArguments);
    }

    public void markVerified() {
        this.verified = true;
    }

    public StubInfo stubInfo() {
        return this.stubInfo;
    }

    public void markStubbed(StubInfo stubInfo) {
        this.stubInfo = stubInfo;
    }

    public boolean isIgnoredForVerification() {
        return this.isIgnoredForVerification;
    }

    public void ignoreForVerification() {
        this.isIgnoredForVerification = true;
    }
}

