/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.mockito.internal.matchers.ContainsExtraTypeInformation;
import org.mockito.internal.reporting.PrintSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchersPrinter {
    public String getArgumentsLine(List<Matcher> matchers, PrintSettings printSettings) {
        StringDescription result = new StringDescription();
        result.appendList("(", ", ", ");", this.applyPrintSettings(matchers, printSettings));
        return result.toString();
    }

    public String getArgumentsBlock(List<Matcher> matchers, PrintSettings printSettings) {
        StringDescription result = new StringDescription();
        result.appendList("(\n    ", ",\n    ", "\n);", this.applyPrintSettings(matchers, printSettings));
        return result.toString();
    }

    private List<SelfDescribing> applyPrintSettings(List<Matcher> matchers, PrintSettings printSettings) {
        LinkedList<SelfDescribing> withPrintSettings = new LinkedList<SelfDescribing>();
        int i = 0;
        for (Matcher matcher : matchers) {
            if (matcher instanceof ContainsExtraTypeInformation && printSettings.extraTypeInfoFor(i)) {
                withPrintSettings.add(((ContainsExtraTypeInformation)matcher).withExtraTypeInfo());
            } else {
                withPrintSettings.add((SelfDescribing)matcher);
            }
            ++i;
        }
        return withPrintSettings;
    }
}

