/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import alma.acs.logging.ClientLogManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.wrappers.ArchiveTimeStamp;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;

public class ASDMQueryClient {
    static Logger m_logger;
    static String schema;
    static String attributeName;
    static String attributeValue;
    static ArchiveTimeStamp timeFrom;
    static ArchiveTimeStamp timeTo;
    static FileWriter out;
    static int parsePosition;

    public static void main(String[] args) throws IOException, DatabaseException, ModuleCriticalException, ArchiveException {
        block16: {
            m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("ASDMQueryClient", false);
            if (args.length < 1) {
                ASDMQueryClient.inputError("Schema name must be specified.");
                return;
            }
            if (args[parsePosition].equals("-i")) {
                ASDMQueryClient.printHelp();
                return;
            }
            schema = args[parsePosition];
            ++parsePosition;
            if (args.length > 2 && args[1].equals("-w")) {
                ++parsePosition;
                if (args.length < 3) {
                    ASDMQueryClient.inputError("Switch -w must be followed by filename.");
                    return;
                }
                out = new FileWriter(args[parsePosition]);
                System.out.println("Writing matching XML files contents to file " + args[parsePosition]);
                ++parsePosition;
            }
            if (args.length <= parsePosition) {
                ASDMQueryClient.query();
                return;
            }
            try {
                timeFrom = new ArchiveTimeStamp(args[parsePosition]);
                ++parsePosition;
            }
            catch (Exception e) {
                timeFrom = null;
                if (!args[parsePosition].equals("0")) break block16;
                ++parsePosition;
                try {
                    timeFrom = new ArchiveTimeStamp("2000-01-01T12:00:00.000");
                }
                catch (DatabaseException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (args.length <= parsePosition) {
            ASDMQueryClient.query();
            return;
        }
        if (timeFrom != null) {
            try {
                timeTo = new ArchiveTimeStamp(args[parsePosition]);
                ++parsePosition;
            }
            catch (Exception e) {
                timeTo = new ArchiveTimeStamp();
            }
        }
        if (args.length <= parsePosition) {
            ASDMQueryClient.query();
            return;
        }
        attributeName = args[parsePosition];
        if (args.length <= ++parsePosition) {
            ASDMQueryClient.query();
            return;
        }
        attributeValue = "";
        for (int i = parsePosition; i < args.length - 1; ++i) {
            attributeValue = attributeValue + args[i] + " ";
        }
        attributeValue = attributeValue + args[args.length - 1];
        ASDMQueryClient.query();
    }

    private static void query() throws DatabaseException, ModuleCriticalException, IOException, ArchiveException {
        Object query;
        if (timeFrom == null) {
            timeFrom = new ArchiveTimeStamp("2000-01-01T12:00:00.000");
        }
        if (timeTo == null) {
            timeTo = new ArchiveTimeStamp();
        }
        System.out.println("Querying observation data for schema " + schema + " from " + timeFrom.toISOString() + " to " + timeTo.toISOString() + ".");
        if (attributeName != null) {
            System.out.println("Querying for attribute " + attributeName + (String)(attributeValue == null ? "" : " with value " + attributeValue) + ".");
        }
        if (attributeName == null) {
            query = "/*";
        } else if (attributeName.startsWith("@")) {
            query = "//*[attribute::" + attributeName.substring(1) + (String)(attributeValue == null ? "" : "='" + attributeValue + "'") + "]";
        } else {
            query = "//" + attributeName;
            if (attributeValue != null) {
                query = (String)query + "[contains(., \"" + attributeValue + "\")]";
            }
        }
        InternalIF internal = InternalIFFactory.getInternalIF(m_logger);
        try {
            internal.getSchemaManager("asdmQuery").getSchemaURI(schema);
        }
        catch (UnknownSchemaException e) {
            System.out.println("Schema " + schema + " is unknown. Please check your query or the database connection used.");
            return;
        }
        m_logger.info("Constructed XPath query: " + (String)query);
        URI[] uids = internal.queryInterval(timeFrom, timeTo, schema, (String)query, "asdmQueryClient");
        for (int i = 0; i < uids.length; ++i) {
            if (attributeName != null) {
                System.out.print(attributeName);
                if (attributeValue != null) {
                    System.out.print("='" + attributeValue + "'");
                }
                System.out.print(": ");
            }
            System.out.println(uids[i]);
            if (out == null) continue;
            try {
                out.write(internal.get(uids[i], "asdmQueryClient"));
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR: Could not retrieve matching " + uids[i] + " from XMLstore!");
            }
        }
        System.out.println("Found " + uids.length + " matching results.");
        if (out != null) {
            out.close();
        }
    }

    public static void inputError(String message) {
        System.out.println("ERROR: " + message);
        System.out.println("");
        ASDMQueryClient.printHelp();
    }

    public static void printHelp() {
        System.out.println("Usage: asdmQuery schemaName (-w filename)? timeFrom? timeTo? (name value?)?");
        System.out.println("Retrieves documents belonging to a given schema (schemaName) in a given time interval (timeFrom and timeTo, if either is not specified, beginning or end of history is used).");
        System.out.println("Retrieved results can be restricted to ones having a given attribute or element (name) with a value or content (value). If value is specified, ");
        System.out.println("name must also be specified. If name is prefixed with @, then it specifies an attribute, otherwise an element.");
        System.out.println("Documents returned will be the ones who have the specified attribute or element at any place in the document structure, with the specified value contained.");
        System.out.println("Values may contain blanks, but values containing symbols like ( or ) must be enclosed in \". Values must not contain \" or '.");
        System.out.println("If timeTo is given, timeFrom must also be specified. If you want to query all data until a given time, you can use 0 for timeFrom.");
        System.out.println("Timestamps have to be specified in ISO format with milliseconds, eg.: 2006-12-31T23:59:59.000, and refer to database *storage* time, not creation time.");
        System.out.println("Names have to be given with namespace prefix, eg. prj, if necessary. If specifying an attribute the @ symbol must precede the namespace prefix.");
        System.out.println("If -w is specified, the full contents (not just the matching parts) of all matching XML documents will be written to the specified filename.");
        System.out.println("Logging can be drastically reduced by setting ACS_LOG_STDOUT to 99");
        System.out.println("");
        System.out.println("EXAMPLE: Query for all Holography (truncated, test) projects until 2006:");
        System.out.println("   asdmQuery ObsProject 0 2006-12-31T23:59:59.000 prj:projectName Holography Testing - truncated");
        System.out.println("EXAMPLE: Query for projects using km/s as velocity unit:");
        System.out.println("   asdmQuery ObsProject @unit km/s");
        System.out.println("EXAMPLE: Query for all projects starting with 2006 referencing a given part ID and concatenate the full XML files in file testfile.txt:");
        System.out.println("   asdmQuery ObsProject -w testfile.txt 2006-01-01T00:00:00.000 @prj:entityPartId 1164141831796/29263776 1606933650");
        System.out.println("IMPORTANT NOTE: asdmQuery will always use the archiveConfig.properties file in $ACSDATA/config");
    }

    static {
        parsePosition = 0;
    }
}

