/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache;

import java.util.concurrent.atomic.AtomicLong;

public class Statistics {
    private volatile boolean active = true;
    private final AtomicLong removals = new AtomicLong();
    private final AtomicLong expiries = new AtomicLong();
    private final AtomicLong puts = new AtomicLong();
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();
    private final AtomicLong putTimeTaken = new AtomicLong();
    private final AtomicLong getTimeTaken = new AtomicLong();
    private final AtomicLong removeTimeTaken = new AtomicLong();

    public long getHits() {
        return this.hits.get();
    }

    public long getMisses() {
        return this.misses.get();
    }

    public long getPuts() {
        return this.puts.get();
    }

    public long getRemovals() {
        return this.removals.get();
    }

    public long getEvictions() {
        return this.evictions.get();
    }

    public long getTimeTakenForGets() {
        return this.getTimeTaken.get();
    }

    public long getTimeTakenForPuts() {
        return this.putTimeTaken.get();
    }

    public long getTimeTakenForRemovals() {
        return this.removeTimeTaken.get();
    }

    public void increaseRemovals(long number) {
        this.increment(this.removals, number);
    }

    public void increaseExpiries(long number) {
        this.increment(this.expiries, number);
    }

    public void increasePuts(long number) {
        this.increment(this.puts, number);
    }

    public void increaseHits(long number) {
        this.increment(this.hits, number);
    }

    public void increaseMisses(long number) {
        this.increment(this.misses, number);
    }

    public void increaseEvictions(long number) {
        this.increment(this.evictions, number);
    }

    public void addGetTime(long duration) {
        this.increment(duration, this.getTimeTaken);
    }

    public void addPutTime(long duration) {
        this.increment(duration, this.putTimeTaken);
    }

    public void addRemoveTime(long duration) {
        this.increment(duration, this.removeTimeTaken);
    }

    private void increment(AtomicLong counter, long number) {
        if (!this.active) {
            return;
        }
        counter.addAndGet(number);
    }

    private void increment(long duration, AtomicLong counter) {
        if (!this.active) {
            return;
        }
        if (counter.get() < Long.MAX_VALUE - duration) {
            counter.addAndGet(duration);
        } else {
            this.reset();
            counter.set(duration);
        }
    }

    public void reset() {
        this.puts.set(0L);
        this.misses.set(0L);
        this.removals.set(0L);
        this.expiries.set(0L);
        this.hits.set(0L);
        this.evictions.set(0L);
        this.getTimeTaken.set(0L);
        this.putTimeTaken.set(0L);
        this.removeTimeTaken.set(0L);
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

