/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.makesupport;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class AcsFileFinder {
    protected boolean verbose = false;
    protected Map<String, File> m_fileMap;
    protected Logger m_logger;

    public AcsFileFinder(File[] dirs, Logger logger) {
        this(dirs, null, logger);
    }

    public AcsFileFinder(File[] dirs, FilenameFilter filenameFilter, Logger logger) {
        this.m_logger = logger;
        this.scanDirs(dirs, filenameFilter);
    }

    public void setVerbose(boolean verbose) {
        if (this.m_logger != null) {
            this.verbose = verbose;
        }
    }

    private void scanDirs(File[] dirs, FilenameFilter filenameFilter) {
        this.m_fileMap = new LinkedHashMap<String, File>();
        if (dirs == null || dirs.length == 0) {
            return;
        }
        for (int i = 0; i < dirs.length; ++i) {
            File dir = dirs[i];
            if (dir == null || !dir.exists() || !dir.isDirectory() || !dir.canRead()) continue;
            String[] filenames = null;
            filenames = filenameFilter != null ? dir.list(filenameFilter) : dir.list();
            for (int j = 0; j < filenames.length; ++j) {
                String filename = filenames[j];
                File file = new File(dir, filename);
                if (!file.isFile()) continue;
                File existing = this.m_fileMap.get(filename);
                if (existing != null) {
                    if (!this.verbose) continue;
                    this.m_logger.finer("skipping " + file.getAbsolutePath() + " in favor of " + existing.getAbsolutePath());
                    continue;
                }
                if (this.verbose) {
                    this.m_logger.finer("adding " + file.getAbsolutePath());
                }
                this.m_fileMap.put(filename, file);
            }
        }
    }

    public File[] getAllFiles() {
        File[] files = this.m_fileMap.values().toArray(new File[this.m_fileMap.size()]);
        return files;
    }

    public File[] getFiles(FilenameFilter filter) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : this.m_fileMap.values()) {
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            fileList.add(file);
        }
        return fileList.toArray(new File[fileList.size()]);
    }
}

