/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.TablePlotter;
import jsky.catalog.gui.TableSymbolConfigGUI;
import jsky.util.I18N;
import jsky.util.IApplyCancel;
import jsky.util.Resources;
import jsky.util.TclUtil;
import jsky.util.gui.TabbedPaneDialog;
import jsky.util.gui.TabbedPanel;

public class TableSymbolConfig
extends TableSymbolConfigGUI
implements IApplyCancel {
    private static final I18N _I18N = I18N.getInstance(TableSymbolConfig.class);
    private TablePlotter _plotter;
    private TableQueryResult _table;
    private int _selectedSymbolRow = 0;
    private TablePlotSymbol[] _symbols;
    private Icon[] _symbolIcons;
    public static final String[] COL_NAMES = new String[]{_I18N.getString("columns"), _I18N.getString("symbol"), _I18N.getString("color"), _I18N.getString("ratio"), _I18N.getString("angle"), _I18N.getString("label"), _I18N.getString("condition"), _I18N.getString("size"), _I18N.getString("units")};
    public static final int COLUMNS = 0;
    public static final int SYMBOL = 1;
    public static final int COLOR = 2;
    public static final int RATIO = 3;
    public static final int ANGLE = 4;
    public static final int LABEL = 5;
    public static final int CONDITION = 6;
    public static final int SIZE = 7;
    public static final int UNITS = 8;
    public static final String[] UNIT_NAMES = new String[]{_I18N.getString("imagePixels"), _I18N.getString("wcsDeg")};
    public static final String[] UNIT_STRINGS = new String[]{"image", "deg"};
    public static final int IMAGE_PIXEL_UNITS = 0;
    public static final int WCS_DEG_UNITS = 1;

    public TableSymbolConfig(TablePlotter plotter, TableQueryResult table) {
        this._plotter = plotter;
        this.symbolTable.setSelectionMode(0);
        this.symbolTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int first = e.getFirstIndex();
                int last = e.getLastIndex();
                ListSelectionModel model = TableSymbolConfig.this.symbolTable.getSelectionModel();
                int i = first;
                while (i <= last) {
                    if (model.isSelectedIndex(i) && i >= 0 && i < TableSymbolConfig.this._symbols.length) {
                        TableSymbolConfig.this._selectedSymbolRow = i;
                        TableSymbolConfig.this.editSymbol(TableSymbolConfig.this._symbols[i]);
                        break;
                    }
                    ++i;
                }
            }
        });
        this.symbolTable.setRowSelectionAllowed(true);
        this.symbolTable.setColumnSelectionAllowed(false);
        this.symbolTable.setAutoResizeMode(0);
        this.symbolTable.setRowHeight(20);
        this.symbolTable.setGridColor(Color.gray);
        this.useList.setModel(new DefaultListModel());
        this.ignoreList.setModel(new DefaultListModel());
        this._symbolIcons = new Icon[TablePlotSymbol.SYMBOLS.length];
        int i = 0;
        while (i < TablePlotSymbol.SYMBOLS.length) {
            this._symbolIcons[i] = Resources.getIcon((String)("symb_" + TablePlotSymbol.SYMBOLS[i] + ".gif"));
            this.symbolComboBox.addItem(this._symbolIcons[i]);
            ++i;
        }
        this.symbolComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSymbolConfig.this.symbolSelected();
            }
        });
        i = 0;
        while (i < TablePlotSymbol.COLOR_NAMES.length) {
            this.colorComboBox.addItem(TablePlotSymbol.COLOR_NAMES[i]);
            ++i;
        }
        String[] stringArray = UNIT_NAMES;
        int n = UNIT_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.unitsComboBox.addItem(name);
            ++n2;
        }
        this.setTable(table);
    }

    protected void symbolSelected() {
        boolean enabled = true;
        Object o = this.symbolComboBox.getSelectedItem();
        int i = 0;
        while (i < this._symbolIcons.length) {
            if (o.equals(this._symbolIcons[i])) {
                switch (i) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: {
                        enabled = false;
                    }
                }
                break;
            }
            ++i;
        }
        this.ratioTextField.setEnabled(enabled);
        this.angleTextField.setEnabled(enabled);
    }

    public void setTable(TableQueryResult table) {
        this._table = table;
        this._symbols = this._plotter.getPlotSymbolInfo(this._table);
        if (this._symbols == null) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(this._symbols.length > 1);
        Object[][] data = new String[this._symbols.length][COL_NAMES.length];
        int i = 0;
        while (i < this._symbols.length) {
            TablePlotSymbol symb = this._symbols[i];
            int j = 0;
            while (j < COL_NAMES.length) {
                String s = "";
                switch (j) {
                    case 0: {
                        s = symb.getColNamesList();
                        break;
                    }
                    case 1: {
                        s = symb.getShapeName();
                        break;
                    }
                    case 2: {
                        s = symb.getColorName(symb.getFg());
                        break;
                    }
                    case 3: {
                        s = symb.getRatio();
                        break;
                    }
                    case 4: {
                        s = symb.getAngle();
                        break;
                    }
                    case 5: {
                        s = symb.getLabel();
                        break;
                    }
                    case 6: {
                        s = symb.getCond();
                        break;
                    }
                    case 7: {
                        s = symb.getSize();
                        break;
                    }
                    case 8: {
                        s = symb.getUnits();
                    }
                }
                data[i][j] = s;
                ++j;
            }
            ++i;
        }
        this.symbolTable.setModel(new DefaultTableModel(data, COL_NAMES){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        this.symbolTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    protected void setListData(JList list, String[] ar) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        model.removeAllElements();
        if (ar != null) {
            String[] stringArray = ar;
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                model.addElement(s);
                ++n2;
            }
        }
    }

    protected void setListData(JList jList, List<String> list) {
        DefaultListModel model = (DefaultListModel)jList.getModel();
        model.removeAllElements();
        if (list != null) {
            int n = list.size();
            int i = 0;
            while (i < n) {
                model.addElement(list.get(i));
                ++i;
            }
        }
    }

    protected void editSymbol(TablePlotSymbol symb) {
        int n;
        String[] used = symb.getColNames();
        this.setListData(this.useList, used);
        Vector v = this._table.getColumnIdentifiers();
        int size = v.size();
        ArrayList<String> ignore = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            String s = (String)v.get(i);
            if (used == null) {
                ignore.add(s);
            } else {
                String[] stringArray = used;
                n = used.length;
                int n2 = 0;
                while (n2 < n) {
                    String u = stringArray[n2];
                    if (!s.equals(u)) {
                        ignore.add(s);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        this.setListData(this.ignoreList, ignore);
        String shapeName = symb.getShapeName();
        String[] ar = TablePlotSymbol.SYMBOLS;
        int i2 = 0;
        while (i2 < ar.length) {
            if (shapeName.equals(ar[i2])) {
                this.symbolComboBox.getModel().setSelectedItem(this._symbolIcons[i2]);
                break;
            }
            ++i2;
        }
        String colorName = symb.getColorName(symb.getFg());
        String[] stringArray = ar = TablePlotSymbol.COLOR_NAMES;
        int n3 = ar.length;
        n = 0;
        while (n < n3) {
            String name = stringArray[n];
            if (colorName.equals(name)) {
                this.colorComboBox.getModel().setSelectedItem(name);
                break;
            }
            ++n;
        }
        String units = symb.getUnits();
        if (units.startsWith("deg")) {
            this.unitsComboBox.getModel().setSelectedItem(UNIT_NAMES[1]);
        } else {
            this.unitsComboBox.getModel().setSelectedItem(UNIT_NAMES[0]);
        }
        this.ratioTextField.setText(symb.getRatio());
        this.angleTextField.setText(symb.getAngle());
        this.labelTextField.setText(symb.getLabel());
        this.conditionTextField.setText(symb.getCond());
        this.sizeTextField.setText(symb.getSize());
    }

    protected void updateSymbolTable() {
        DefaultTableModel tableModel = (DefaultTableModel)this.symbolTable.getModel();
        Object[] ar = ((DefaultListModel)this.useList.getModel()).toArray();
        String value = TclUtil.makeList((Object[])ar);
        tableModel.setValueAt(value, this._selectedSymbolRow, 0);
        Object o = this.symbolComboBox.getSelectedItem();
        int i = 0;
        while (i < this._symbolIcons.length) {
            if (o.equals(this._symbolIcons[i])) {
                tableModel.setValueAt(TablePlotSymbol.SYMBOLS[i], this._selectedSymbolRow, 1);
                break;
            }
            ++i;
        }
        String color = (String)this.colorComboBox.getSelectedItem();
        tableModel.setValueAt(color, this._selectedSymbolRow, 2);
        tableModel.setValueAt(this.ratioTextField.getText(), this._selectedSymbolRow, 3);
        tableModel.setValueAt(this.angleTextField.getText(), this._selectedSymbolRow, 4);
        tableModel.setValueAt(this.labelTextField.getText(), this._selectedSymbolRow, 5);
        tableModel.setValueAt(this.conditionTextField.getText(), this._selectedSymbolRow, 6);
        tableModel.setValueAt(this.sizeTextField.getText(), this._selectedSymbolRow, 7);
        String units = UNIT_STRINGS[this.unitsComboBox.getSelectedIndex()];
        tableModel.setValueAt(units, this._selectedSymbolRow, 8);
    }

    protected TablePlotSymbol[] getPlotSymbolInfo() {
        this.updateSymbolTable();
        DefaultTableModel tableModel = (DefaultTableModel)this.symbolTable.getModel();
        int numRows = tableModel.getRowCount();
        TablePlotSymbol[] symbols = new TablePlotSymbol[numRows];
        int i = 0;
        while (i < numRows) {
            symbols[i] = new TablePlotSymbol();
            symbols[i].setColNames(TclUtil.splitList((String)((String)tableModel.getValueAt(i, 0))));
            symbols[i].setShapeName((String)tableModel.getValueAt(i, 1));
            symbols[i].setFg((String)tableModel.getValueAt(i, 2));
            symbols[i].setBg(symbols[i].getFg());
            symbols[i].setRatio((String)tableModel.getValueAt(i, 3));
            symbols[i].setAngle((String)tableModel.getValueAt(i, 4));
            symbols[i].setLabel((String)tableModel.getValueAt(i, 5));
            symbols[i].setCond((String)tableModel.getValueAt(i, 6));
            symbols[i].setSize((String)tableModel.getValueAt(i, 7));
            symbols[i].setUnits((String)tableModel.getValueAt(i, 8));
            ++i;
        }
        return symbols;
    }

    @Override
    void leftArrowButton_actionPerformed(ActionEvent e) {
        Object o = this.ignoreList.getSelectedValue();
        if (o instanceof String) {
            ((DefaultListModel)this.ignoreList.getModel()).remove(this.ignoreList.getSelectedIndex());
            ((DefaultListModel)this.useList.getModel()).addElement(o);
        }
    }

    @Override
    void rightArrowButton_actionPerformed(ActionEvent e) {
        Object o = this.useList.getSelectedValue();
        if (o instanceof String) {
            ((DefaultListModel)this.useList.getModel()).remove(this.useList.getSelectedIndex());
            ((DefaultListModel)this.ignoreList.getModel()).addElement(o);
        }
    }

    @Override
    void addButton_actionPerformed(ActionEvent e) {
        Object[] ar = new Object[COL_NAMES.length];
        ar[0] = "";
        ar[1] = "square";
        ar[2] = "yellow";
        ar[3] = "";
        ar[4] = "";
        ar[5] = "";
        ar[6] = "";
        ar[7] = "4";
        ar[8] = "";
        DefaultTableModel tableModel = (DefaultTableModel)this.symbolTable.getModel();
        int numRows = tableModel.getRowCount();
        tableModel.addRow(ar);
        this.removeButton.setEnabled(true);
        TablePlotSymbol[] oldSymbols = this._symbols;
        int n = 0;
        if (oldSymbols != null) {
            n = oldSymbols.length;
            this._symbols = new TablePlotSymbol[n + 1];
            System.arraycopy(oldSymbols, 0, this._symbols, 0, n);
        } else {
            this._symbols = new TablePlotSymbol[1];
        }
        this._symbols[n] = new TablePlotSymbol();
        this._symbols[n].setTable(this._table);
        this.symbolTable.getSelectionModel().setSelectionInterval(numRows, numRows);
    }

    @Override
    void removeButton_actionPerformed(ActionEvent e) {
        DefaultTableModel tableModel = (DefaultTableModel)this.symbolTable.getModel();
        int numRows = tableModel.getRowCount();
        if (this._symbols.length > 1 && numRows > 1 && this._selectedSymbolRow >= 0 && this._selectedSymbolRow < numRows) {
            tableModel.removeRow(this._selectedSymbolRow);
            TablePlotSymbol[] oldSymbols = this._symbols;
            this._symbols = new TablePlotSymbol[oldSymbols.length - 1];
            int n = 0;
            int i = 0;
            while (i < numRows) {
                if (i != this._selectedSymbolRow) {
                    this._symbols[n++] = oldSymbols[i];
                }
                ++i;
            }
            if (--this._selectedSymbolRow < 0) {
                this._selectedSymbolRow = 0;
            }
            this.symbolTable.getSelectionModel().setSelectionInterval(this._selectedSymbolRow, this._selectedSymbolRow);
        }
        this.removeButton.setEnabled(this._symbols.length > 1);
    }

    public void apply() {
        this._symbols = this.getPlotSymbolInfo();
        this._plotter.setPlotSymbolInfo(this._table, this._symbols);
        this._plotter.unplot(this._table);
        this._plotter.plot(this._table);
        PlotableCatalog cat = (PlotableCatalog)this._table.getCatalog();
        if (cat != null) {
            cat.setSymbols(this._symbols);
            cat.setSymbolsEdited(true);
            CatalogDirectory rootDir = null;
            CatalogDirectory catDir = cat.getParent();
            if (catDir != null) {
                rootDir = (CatalogDirectory)catDir.getRoot();
            }
            if (rootDir != null) {
                Catalog existingCat = rootDir.getCatalog(cat.getName());
                if (existingCat != null && existingCat != cat) {
                    rootDir.removeCatalog(existingCat);
                }
                rootDir.addCatalog(1, (Catalog)cat);
                rootDir.save();
            }
        }
    }

    public void cancel() {
        if (this._symbols != null) {
            this.editSymbol(this._symbols[this._selectedSymbolRow]);
        }
    }

    public static void main(String[] args) {
        TabbedPaneDialog tpf = new TabbedPaneDialog(null, "Test");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        TabbedPanel tp = tpf.getTabbedPanel();
        JTabbedPane jtp = tp.getTabbedPane();
        jtp.add((Component)new TableSymbolConfigGUI(), "Test1");
        tp.getOKButton().addActionListener(al);
        tp.getCancelButton().addActionListener(al);
        tpf.pack();
        tpf.setVisible(true);
    }
}

