/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatTable;
import jsky.catalog.vo.VoCatalog;
import jsky.catalog.vo.VoTable;
import jsky.navigator.Navigator;
import jsky.util.gui.DialogUtil;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.TableHDU;
import nom.tam.util.BufferedDataOutputStream;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.ByteArrayDataSource;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.votable.FitsPlusTableBuilder;
import uk.ac.starlink.votable.FitsPlusTableWriter;

public class NavigatorFITSTable
extends SkycatTable {
    protected static final String CATINFO = "CATINFO";
    protected static final String VOTMETA = "VOTMETA_";
    protected static final String TABLE_SUFFIX = " (FITS Table)";
    protected static final String[] CATINFO_COLUMNS = new String[]{"SHORT_NAME", "ID_COL", "RA_COL", "DEC_COL", "X_COL", "Y_COL", "EQUINOX", "SYMBOL", "SEARCH_COLS", "COPYRIGHT"};
    private Header _header;

    public NavigatorFITSTable(String filename, Fits fits, TableHDU hdu) throws FitsException, IOException {
        this._header = hdu.getHeader();
        this.setFilename(filename);
        int ncols = hdu.getNCols();
        int nrows = hdu.getNRows();
        this.dataVector = new Vector(nrows);
        this.columnIdentifiers = new Vector(ncols);
        ArrayList<Object> columnClasses = new ArrayList<Object>(ncols);
        FieldDescAdapter[] fields = new FieldDescAdapter[ncols];
        Header header = hdu.getHeader();
        String name = header.getStringValue("EXTNAME");
        if (name == null) {
            name = "FITS Table";
        }
        this.setName(name);
        this.setTitle(name);
        this.setId(name);
        int i = 0;
        while (i < ncols) {
            String colName = hdu.getColumnName(i);
            this.columnIdentifiers.add(colName);
            fields[i] = new FieldDescAdapter(colName);
            columnClasses.add(null);
            ++i;
        }
        this.setColumnClasses(columnClasses);
        this.setFields((FieldDesc[])fields);
        if (nrows > 0) {
            i = 0;
            while (i < nrows) {
                Object[] row = hdu.getRow(i);
                Vector<Object> v = new Vector<Object>(ncols);
                int j = 0;
                while (j < ncols) {
                    Object o = row[j];
                    if (o.getClass().isArray()) {
                        o = Array.get(o, 0);
                    }
                    this._checkColumnClass(j, o);
                    v.add(o);
                    ++j;
                }
                this.dataVector.add(v);
                ++i;
            }
        }
        try {
            SkycatConfigEntry entry = this.findConfigEntry(fits);
            if (entry != null) {
                this.setConfigEntry(entry);
            }
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public static TableQueryResult getTable(String filename, Fits fits, TableHDU hdu) throws FitsException, IOException {
        String votMetaName;
        BasicHDU votMetaHdu;
        Header header = hdu.getHeader();
        String name = header.getStringValue("EXTNAME");
        if (name != null && (votMetaHdu = NavigatorFITSTable.findHDU(fits, votMetaName = VOTMETA + name.replace(TABLE_SUFFIX, ""))) != null) {
            Fits tmpFits = new Fits();
            tmpFits.addHDU(votMetaHdu);
            tmpFits.addHDU((BasicHDU)hdu);
            votMetaHdu.getHeader().removeCard("EXTNAME");
            votMetaHdu.getHeader().removeCard("EXTEND");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BufferedDataOutputStream bos = new BufferedDataOutputStream((OutputStream)os);
            tmpFits.write((DataOutput)bos);
            bos.flush();
            votMetaHdu.getHeader().addValue("EXTNAME", votMetaName, "Table metadata in VOTable format");
            ByteArrayDataSource dataSrc = new ByteArrayDataSource(filename, os.toByteArray());
            bos.close();
            StarTable starTable = new FitsPlusTableBuilder().makeStarTable((DataSource)dataSrc, true, StoragePolicy.getDefaultPolicy());
            dataSrc.close();
            VoTable table = VoTable.createVoTable((StarTable)starTable, null, (int)1000000);
            table.setName(name);
            new VoCatalog(table);
            return table;
        }
        return new NavigatorFITSTable(filename, fits, hdu);
    }

    public static TableQueryResult getTable(String filename, Fits fits, int hduIndex) throws IOException, FitsException {
        return NavigatorFITSTable.getTable(filename, fits, NavigatorFITSTable.getTableHDU(fits, hduIndex));
    }

    public Header getHeader() {
        return this._header;
    }

    public static NavigatorFITSTable getFitsTable(String filename) throws FitsException, IOException {
        Fits fits = new Fits(filename);
        fits.read();
        int n = fits.getNumberOfHDUs();
        if (n != 2) {
            throw new IllegalArgumentException("Wrong file format: Expected FITS file with one table.");
        }
        BasicHDU basicHDU = fits.getHDU(1);
        if (!(basicHDU instanceof TableHDU)) {
            throw new IllegalArgumentException("Wrong file format: First FITS extension is not a table.");
        }
        TableHDU hdu = (TableHDU)basicHDU;
        return new NavigatorFITSTable(filename, fits, hdu);
    }

    private static TableHDU getTableHDU(Fits fits, int hduIndex) throws IOException, FitsException {
        BasicHDU basicHDU = fits.getHDU(hduIndex);
        if (!(basicHDU instanceof TableHDU)) {
            throw new RuntimeException("HDU type not supported: " + basicHDU.getClass());
        }
        return (TableHDU)basicHDU;
    }

    protected SkycatConfigEntry findConfigEntry(Fits fits) throws FitsException, IOException {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, CATINFO);
        if (hdu == null) {
            return null;
        }
        int ncols = hdu.getNCols();
        int rowIndex = NavigatorFITSTable.findConfigEntryRow(hdu, name);
        if (rowIndex == -1) {
            return null;
        }
        Object[] row = hdu.getRow(rowIndex);
        Properties properties = new Properties();
        properties.setProperty("serv_type", "local");
        properties.setProperty("long_name", name);
        properties.setProperty("url", this.getFilename());
        int colIndex = 0;
        while (colIndex < ncols) {
            String value = (String)row[colIndex];
            if (value.length() != 0) {
                properties.setProperty(hdu.getColumnName(colIndex).toLowerCase(), value);
            }
            ++colIndex;
        }
        return new SkycatConfigEntry(properties);
    }

    protected static int findConfigEntryRow(BinaryTableHDU hdu, String name) throws FitsException {
        int nrows = hdu.getNRows();
        int rowIndex = 0;
        while (rowIndex < nrows) {
            String extName = (String)hdu.getElement(rowIndex, 0);
            if (extName.equals(name)) {
                return rowIndex;
            }
            ++rowIndex;
        }
        return -1;
    }

    protected static BasicHDU findHDU(Fits fits, String name) throws FitsException, IOException {
        if (name == null) {
            return null;
        }
        int n = fits.getNumberOfHDUs();
        int hduIndex = 0;
        while (hduIndex < n) {
            BasicHDU basicHDU = fits.getHDU(hduIndex);
            Header header = basicHDU.getHeader();
            String extName = header.getStringValue("EXTNAME");
            if (extName != null && extName.equals(name)) {
                return basicHDU;
            }
            ++hduIndex;
        }
        return null;
    }

    protected static BinaryTableHDU findBinaryTableHDU(Fits fits, String name) throws FitsException, IOException {
        BasicHDU basicHDU = NavigatorFITSTable.findHDU(fits, name);
        if (basicHDU instanceof BinaryTableHDU) {
            return (BinaryTableHDU)basicHDU;
        }
        return null;
    }

    public static TableQueryResult saveWithImage(String filename, Fits fits, TableQueryResult table) throws FitsException, IOException {
        int nrows = table.getRowCount();
        int ncols = table.getColumnCount();
        if (nrows == 0 || ncols == 0) {
            return null;
        }
        String tableName = NavigatorFITSTable.getTableName(filename, table);
        String votMetaName = VOTMETA + tableName.replace(TABLE_SUFFIX, "");
        if (!tableName.endsWith(TABLE_SUFFIX)) {
            tableName = String.valueOf(tableName) + TABLE_SUFFIX;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        new FitsPlusTableWriter().writeStarTable(table.getStarTable(), (OutputStream)os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        Fits tableFits = new Fits((InputStream)is);
        BasicHDU votMetaHdu = tableFits.getHDU(0);
        votMetaHdu.getHeader().addValue("EXTNAME", votMetaName, "Table metadata in VOTable format");
        TableHDU hdu = (TableHDU)tableFits.getHDU(1);
        hdu.getHeader().addValue("EXTNAME", tableName, "Contains saved query results");
        is.close();
        os.close();
        NavigatorFITSTable.deleteTable(fits, tableName);
        fits.addHDU((BasicHDU)hdu);
        if (!(table instanceof SkycatTable)) {
            fits.addHDU(votMetaHdu);
        }
        NavigatorFITSTable._updateCatInfo(fits, table, tableName);
        return NavigatorFITSTable.getTable(filename, fits, hdu);
    }

    protected static String getTableName(String filename, TableQueryResult table) {
        String name = table.getId();
        if (!name.endsWith(TABLE_SUFFIX)) {
            Catalog cat = table.getCatalog();
            if (cat != null) {
                name = cat.getName();
            }
            if (name == null) {
                name = new File(filename).getName();
            }
            if (name.length() > 50) {
                name = name.substring(0, 50);
            }
        }
        return name.replace("=", "_");
    }

    public static void deleteTable(Fits fits, String name) throws FitsException, IOException {
        int numHDUs = fits.getNumberOfHDUs();
        String votMetaName = VOTMETA + name.replace(TABLE_SUFFIX, "");
        int hduIndex = numHDUs - 1;
        while (hduIndex >= 0) {
            BasicHDU basicHDU = fits.getHDU(hduIndex);
            Header header = basicHDU.getHeader();
            String extName = header.getStringValue("EXTNAME");
            if (extName != null && (extName.equals(name) || extName.equals(votMetaName))) {
                fits.deleteHDU(hduIndex);
            }
            --hduIndex;
        }
        NavigatorFITSTable._removeCatInfo(fits, name);
    }

    public static void deleteTable(Fits fits, int hduIndex) throws FitsException, IOException {
        TableHDU hdu = NavigatorFITSTable.getTableHDU(fits, hduIndex);
        String name = hdu.getHeader().getStringValue("EXTNAME");
        NavigatorFITSTable.deleteTable(fits, name);
    }

    private static void _updateCatInfo(Fits fits, TableQueryResult table, String name) throws FitsException, IOException {
        Object[][] data;
        int ncols = CATINFO_COLUMNS.length;
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, CATINFO);
        int newRowIndex = 0;
        if (hdu != null) {
            int nrows = hdu.getNRows();
            int entryIndex = NavigatorFITSTable.findConfigEntryRow(hdu, name);
            int dummyIndex = NavigatorFITSTable.findConfigEntryRow(hdu, "-");
            int n = nrows;
            if (entryIndex == -1) {
                ++n;
            }
            if (dummyIndex == -1) {
                ++n;
            }
            data = new Object[n][];
            int rowIndex = 0;
            while (rowIndex < nrows) {
                if (rowIndex != entryIndex && rowIndex != dummyIndex) {
                    data[newRowIndex++] = NavigatorFITSTable._copyCatInfoRow(hdu, hdu.getRow(rowIndex));
                }
                ++rowIndex;
            }
            NavigatorFITSTable.deleteTable(fits, CATINFO);
        } else {
            data = new Object[2][];
        }
        Object[] row = new Object[ncols];
        row[0] = name;
        if (table instanceof SkycatTable) {
            SkycatConfigEntry entry = ((SkycatTable)table).getConfigEntry();
            Properties properties = entry.getProperties();
            int colIndex = 1;
            while (colIndex < ncols) {
                String value = properties.getProperty(CATINFO_COLUMNS[colIndex].toLowerCase());
                row[colIndex] = value != null ? value : "";
                ++colIndex;
            }
        } else {
            int colIndex = 1;
            while (colIndex < ncols) {
                row[colIndex] = "";
                ++colIndex;
            }
        }
        data[newRowIndex++] = row;
        row = new Object[ncols];
        int colIndex = 0;
        while (colIndex < ncols) {
            row[colIndex] = "-";
            ++colIndex;
        }
        data[newRowIndex] = row;
        BinaryTable binTable = new BinaryTable(data);
        FitsFactory.setUseAsciiTables((boolean)false);
        hdu = (BinaryTableHDU)Fits.makeHDU((Data)binTable);
        hdu.getHeader().addValue("EXTNAME", CATINFO, "Contains catalog config info");
        int i = 0;
        while (i < ncols) {
            hdu.setColumnName(i, CATINFO_COLUMNS[i], null);
            ++i;
        }
        fits.addHDU((BasicHDU)hdu);
    }

    private static Object[] _copyCatInfoRow(BinaryTableHDU hdu, Object[] row) {
        Object[] result = new Object[CATINFO_COLUMNS.length];
        int i = 0;
        while (i < CATINFO_COLUMNS.length) {
            int index = hdu.findColumn(CATINFO_COLUMNS[i]);
            result[i] = index == -1 ? null : row[index];
            ++i;
        }
        return result;
    }

    private static void _removeCatInfo(Fits fits, String name) throws FitsException, IOException {
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, CATINFO);
        if (hdu != null) {
            int rowIndex = NavigatorFITSTable.findConfigEntryRow(hdu, name);
            if (rowIndex != -1) {
                hdu.deleteRows(rowIndex, 1);
            }
            if (hdu.getNRows() <= 1) {
                NavigatorFITSTable.deleteTable(fits, CATINFO);
            }
        }
    }

    public static void plotTables(String filename, Fits fits, Navigator navigator) throws FitsException, IOException {
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, CATINFO);
        if (hdu == null) {
            return;
        }
        int nrows = hdu.getNRows();
        int rowIndex = 0;
        while (rowIndex < nrows) {
            Object[] row = hdu.getRow(rowIndex);
            String name = (String)row[0];
            NavigatorFITSTable._plotTable(filename, fits, navigator, name);
            ++rowIndex;
        }
    }

    private static void _plotTable(String filename, Fits fits, Navigator navigator, String name) throws FitsException, IOException {
        TableQueryResult table = NavigatorFITSTable._findTable(filename, fits, name);
        if (table != null) {
            navigator.setQueryResult((QueryResult)table.getCatalog());
        }
    }

    private static TableQueryResult _findTable(String filename, Fits fits, String name) throws FitsException, IOException {
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, name);
        if (hdu == null) {
            return null;
        }
        return NavigatorFITSTable.getTable(filename, fits, (TableHDU)hdu);
    }
}

