/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.URLDataSource;

public abstract class DataSource {
    private int introLimit;
    private byte[] intro;
    private InputStream strm;
    private Compression compress;
    private String name;
    private String position;
    public static final int DEFAULT_INTRO_LIMIT = 512;
    public static final String MARK_WORKAROUND_PROPERTY = "mark.workaround";
    private static Boolean markWorkaround_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataSource(int introLimit) {
        this.setIntroLimit(introLimit);
    }

    public DataSource() {
        this(512);
    }

    protected abstract InputStream getRawInputStream() throws IOException;

    public URL getURL() {
        return null;
    }

    public int getIntroLimit() {
        return this.introLimit;
    }

    public void setIntroLimit(int limit) {
        if (limit != this.introLimit) {
            this.clearState();
        }
        this.introLimit = limit;
    }

    public long getRawLength() {
        return -1L;
    }

    public synchronized long getLength() {
        if (this.intro != null && this.intro.length < this.introLimit) {
            return this.intro.length;
        }
        long rawleng = this.getRawLength();
        if (rawleng < 0L || this.compress == null || this.compress != Compression.NONE) {
            return -1L;
        }
        if (!$assertionsDisabled && this.compress != Compression.NONE) {
            throw new AssertionError();
        }
        return rawleng;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getSystemId() {
        URL url = this.getURL();
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            return url.getPath();
        }
        return url.toString();
    }

    private synchronized void initialise() throws IOException {
        int b;
        int leng;
        InputStream introStrm;
        InputStream rawStrm = this.getRawInputStream();
        if (this.compress == null) {
            if (!rawStrm.markSupported() || DataSource.getMarkWorkaround()) {
                rawStrm = new BufferedInputStream(rawStrm);
            }
            int nReq = 3;
            rawStrm.mark(nReq);
            byte[] rawbuf = new byte[nReq];
            int nGot = rawStrm.read(rawbuf);
            this.compress = nGot == nReq ? Compression.getCompression(rawbuf) : Compression.NONE;
            rawStrm.reset();
        }
        if (!(introStrm = this.compress.decompress(rawStrm)).markSupported() || DataSource.getMarkWorkaround()) {
            introStrm = new BufferedInputStream(introStrm);
        }
        introStrm.mark(this.introLimit);
        byte[] buf = new byte[this.introLimit];
        for (leng = 0; (b = introStrm.read()) >= 0 && leng < this.introLimit; ++leng) {
            buf[leng] = (byte)b;
        }
        if (leng == this.introLimit) {
            this.intro = buf;
        } else {
            this.intro = new byte[leng];
            System.arraycopy(buf, 0, this.intro, 0, leng);
        }
        if (this.intro.length < this.introLimit) {
            introStrm.close();
        } else {
            try {
                introStrm.reset();
            }
            catch (IOException e) {
                String msg = e.getMessage() + "\n" + "If you have received a " + "\"Resetting to an invalid mark\" error,\n" + "you have probably come across a " + "bug in some library classes (not STILTS ones).\n" + "Try running with -D" + MARK_WORKAROUND_PROPERTY + "=true.";
                throw (IOException)new IOException(msg).initCause(e);
            }
            this.strm = introStrm;
        }
    }

    public synchronized Compression getCompression() throws IOException {
        if (this.compress == null) {
            this.initialise();
        }
        return this.compress;
    }

    public synchronized byte[] getIntro() throws IOException {
        if (this.intro == null) {
            this.initialise();
        }
        return this.intro;
    }

    public synchronized void setCompression(Compression compress) {
        if (this.compress != compress) {
            this.clearState();
            this.compress = compress;
        }
    }

    public synchronized DataSource forceCompression(Compression compress) {
        if (this.compress == null) {
            this.clearState();
            this.compress = compress;
            return this;
        }
        if (this.compress.equals(compress)) {
            return this;
        }
        final DataSource base = this;
        DataSource forced = new DataSource(){

            protected InputStream getRawInputStream() throws IOException {
                return base.getRawInputStream();
            }

            public URL getURL() {
                return base.getURL();
            }
        };
        forced.setName(base.getName());
        forced.setCompression(compress);
        return forced;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.getIntro().length < this.introLimit) {
            return new ByteArrayInputStream(this.intro);
        }
        InputStream result = this.strm == null ? this.getCompression().decompress(this.getRawInputStream()) : this.strm;
        this.strm = null;
        return result;
    }

    public synchronized InputStream getHybridInputStream() throws IOException {
        if (this.getIntro().length < this.introLimit) {
            return new ByteArrayInputStream(this.intro);
        }
        ByteArrayInputStream introStream = new ByteArrayInputStream(this.intro);
        SkipInputStream remainderStream = new SkipInputStream(this.intro.length);
        return new SequenceInputStream(introStream, remainderStream);
    }

    public synchronized void close() {
        if (this.strm != null) {
            try {
                this.strm.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.strm = null;
        }
    }

    public String toString() {
        String result = this.getName();
        try {
            Compression comp = this.getCompression();
            if (comp != Compression.NONE) {
                result = result + " (" + comp + ")";
            }
        }
        catch (IOException e) {
            result = result + " (error determining compression)";
        }
        return result;
    }

    private void clearState() {
        this.close();
        this.intro = null;
        this.strm = null;
        this.compress = null;
    }

    public static DataSource makeDataSource(String loc) throws IOException {
        String name;
        String position;
        int hashpos = loc.indexOf(35);
        if (hashpos > 0) {
            position = loc.substring(hashpos + 1);
            name = loc.substring(0, hashpos);
        } else {
            position = null;
            name = loc;
        }
        try {
            File file = new File(name);
            if (file.exists()) {
                return new FileDataSource(file, position);
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            URL url = new URL(loc);
            return new URLDataSource(url);
        }
        catch (MalformedURLException e) {
            FileNotFoundException e2 = new FileNotFoundException("Not extant file or valid URL: " + name);
            if (name.matches("^[a-zA-Z0-9_\\-]+:.+")) {
                e2.initCause(e);
            }
            throw e2;
        }
    }

    public static DataSource makeDataSource(URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                return new FileDataSource(new File(url.getFile()), url.getRef());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new URLDataSource(url);
    }

    public static InputStream getInputStream(String location) throws IOException {
        InputStream rawStream;
        if (location.equals("-")) {
            rawStream = System.in;
        } else {
            try {
                rawStream = new URL(location).openStream();
            }
            catch (MalformedURLException e) {
                File file = new File(location);
                if (file.exists()) {
                    rawStream = new FileInputStream(file);
                }
                throw new FileNotFoundException("\"" + location + "\" is not a file or valid URL");
            }
        }
        return Compression.decompressStatic(rawStream);
    }

    public static boolean getMarkWorkaround() {
        if (markWorkaround_ == null) {
            try {
                markWorkaround_ = Boolean.valueOf(System.getProperty(MARK_WORKAROUND_PROPERTY));
            }
            catch (Throwable e) {
                markWorkaround_ = Boolean.FALSE;
            }
        }
        return markWorkaround_;
    }

    public static void setMarkWorkaround(boolean workaround) {
        markWorkaround_ = workaround;
    }

    static {
        $assertionsDisabled = !DataSource.class.desiredAssertionStatus();
    }

    private class SkipInputStream
    extends InputStream {
        private InputStream base;
        private final int nskip;

        SkipInputStream(int nskip) {
            this.nskip = nskip;
        }

        private InputStream getBase() throws IOException {
            if (this.base == null) {
                this.base = DataSource.this.getInputStream();
                int i = 0;
                while (i < this.nskip) {
                    int nb = (int)this.base.skip(this.nskip);
                    if (nb > 0) {
                        i += nb;
                        continue;
                    }
                    if (this.base.read() >= 0) {
                        ++i;
                        continue;
                    }
                    throw new EOFException("Unexpected end of file");
                }
            }
            return this.base;
        }

        public int read() throws IOException {
            return this.getBase().read();
        }

        public int read(byte[] b) throws IOException {
            return this.getBase().read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.getBase().read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.getBase().skip(n);
        }

        public int available() throws IOException {
            return this.base == null ? 0 : this.base.available();
        }

        public void close() throws IOException {
            if (this.base != null) {
                this.base.close();
            }
        }

        public boolean markSupported() {
            return false;
        }
    }
}

