/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.restful;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.restful.SourceNameJson;
import alma.common.sourcecatalog.utilities.TextUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MeasurementJson
implements Measurement {
    private Integer id;
    private Integer catalogueId;
    private Integer sourceId;
    private Double ra;
    private Double uvMin;
    private Double uvMax;
    private Double raUncertainty;
    private Double dec;
    private Double decUncertainty;
    private Double sourceRaDeg;
    private Double sourceRaDegUncertainty;
    private Double sourceDecDeg;
    private Double sourceDecDegUncertainty;
    private Double frequency;
    private Double flux;
    private Double fluxUncertainty;
    private Double polarizationDegree;
    private Double polarizationDegreeUncertainty;
    private Double polarizationAngle;
    private Double polarizationAngleUncertainty;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date dateObserved;
    private List<SourceNameJson> names;

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public Integer getCatalogueId() {
        return this.catalogueId;
    }

    @Override
    public Integer getSourceId() {
        return this.sourceId;
    }

    @Override
    public Double getRa() {
        return this.sourceRaDeg;
    }

    @Override
    public Double getUvMin() {
        return MeasurementJson.valueIfValidPositive(this.uvMin);
    }

    @Override
    public Double getUvMax() {
        return MeasurementJson.valueIfValidPositive(this.uvMax);
    }

    @Override
    public Double getRaUncertainty() {
        return this.sourceRaDegUncertainty;
    }

    @Override
    public Double getDec() {
        return this.sourceDecDeg;
    }

    @Override
    public Double getDecUncertainty() {
        return this.sourceDecDegUncertainty;
    }

    @Override
    public Double getFrequency() {
        return this.frequency;
    }

    @Override
    public Double getFlux() {
        return this.flux;
    }

    @Override
    public Double getFluxUncertainty() {
        return this.fluxUncertainty;
    }

    @Override
    public Double getPolarizationDegree() {
        return this.polarizationDegree;
    }

    @Override
    public Double getPolarizationDegreeUncertainty() {
        return this.polarizationDegreeUncertainty;
    }

    @Override
    public Double getPolarizationAngle() {
        return this.polarizationAngle;
    }

    @Override
    public Double getPolarizationAngleUncertainty() {
        return this.polarizationAngleUncertainty;
    }

    @Override
    public Date getDateObserved() {
        return this.dateObserved;
    }

    @Override
    public List<String> getNames() {
        return this.names.stream().map(n -> n.getName()).collect(Collectors.toList());
    }

    @Override
    public String getFormattedName() {
        return TextUtils.join(this.getNames(), "; ");
    }

    public Double getSourceDecDeg() {
        return this.sourceDecDeg;
    }

    public Double getSourceDecDegUncertainty() {
        return this.sourceDecDegUncertainty;
    }

    public Double getSourceRaDegUncertainty() {
        return this.sourceRaDegUncertainty;
    }

    public Double getSourceRaDeg() {
        return this.sourceRaDeg;
    }

    public static Double valueIfValidPositive(Double d) {
        return d != null && 0.0 < d && d < Double.MAX_VALUE ? d : null;
    }

    public String toString() {
        return "Measurement [id=" + this.id + ", catalogueId=" + this.catalogueId + ", sourceId=" + this.sourceId + ", ra=" + this.ra + ", uvMin=" + this.uvMin + ", uvMax=" + this.uvMax + ", raUncertainty=" + this.raUncertainty + ", dec=" + this.dec + ", decUncertainty=" + this.decUncertainty + ", frequency=" + this.frequency + ", flux=" + this.flux + ", fluxUncertainty=" + this.fluxUncertainty + ", polarizationDegree=" + this.polarizationDegree + ", polarizationDegreeUncertainty=" + this.polarizationDegreeUncertainty + ", polarizationAngle=" + this.polarizationAngle + ", polarizationAngleUncertainty=" + this.polarizationAngleUncertainty + ", dateObserved=" + this.dateObserved + ", names=" + this.getNames() + "]";
    }
}

