/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo;

import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;

public class SingleContinuumObservingFrequency
implements ObservingFrequency {
    private final SpectralSetupParameters spectralSetupParameters;
    private Frequency inputFrequency;
    private ObservingFrequency.FrequencyType inputType;
    private int targetIndex = 0;

    public SingleContinuumObservingFrequency(SpectralSetupParameters spectralSetupParameters) {
        this.spectralSetupParameters = spectralSetupParameters;
        this.inputFrequency = spectralSetupParameters.getSingleContinuumFrequency().deepCopy();
        this.inputType = spectralSetupParameters.getScienceSpectralWindowCount(0) > 0 ? (spectralSetupParameters.getScienceSpectralWindow(0, 0).getIsSkyFrequency() ? ObservingFrequency.FrequencyType.SKY_FREQUENCY : ObservingFrequency.FrequencyType.REST_FREQUENCY) : ObservingFrequency.FrequencyType.SKY_FREQUENCY;
    }

    private boolean getIsSkyFrequency() {
        try {
            return this.inputType == ObservingFrequency.FrequencyType.SKY_FREQUENCY;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public ObservingFrequency.FrequencyType getFrequencyType() {
        if (this.getIsSkyFrequency()) {
            return ObservingFrequency.FrequencyType.SKY_FREQUENCY;
        }
        return ObservingFrequency.FrequencyType.REST_FREQUENCY;
    }

    @Override
    public Frequency getRestFrequency() {
        Frequency frequency = this.getInputFrequency();
        if (this.getFrequencyType() == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return this.getSourceVelocity().reverseShift(frequency);
        }
        return frequency.deepCopy();
    }

    @Override
    public Frequency getSkyFrequency() {
        Frequency frequency = this.getInputFrequency();
        if (this.getFrequencyType() == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return frequency.deepCopy();
        }
        return this.getSourceVelocity().dopplerShift(frequency);
    }

    @Override
    public Velocity getSourceVelocity() {
        try {
            TargetParameters targetParameters = this.spectralSetupParameters.getScienceGoal().getTargetParameters(this.targetIndex);
            return targetParameters.getSourceVelocity();
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            return Velocity.createVelocity();
        }
    }

    @Override
    public void setInputFrequency(Frequency frequency) {
        this.inputFrequency = frequency.deepCopy();
    }

    @Override
    public void setFrequencyType(ObservingFrequency.FrequencyType frequencyType) {
        this.inputType = frequencyType;
        this.updateSpectralWindowsForContinuum();
    }

    @Override
    public void setSourceVelocity(Velocity velocity) {
        throw new RuntimeException("This should not be used");
    }

    @Override
    public void setTargetIndex(int n) {
        if (this.targetIndex != n) {
            this.targetIndex = n;
        }
    }

    private void updateSpectralWindowsForContinuum() {
        try {
            this.spectralSetupParameters.updateSingleContinuumWindows(this.getInputFrequency(), this.getSourceVelocity(), this.getFrequencyType(), this.spectralSetupParameters.getCorrPolarization());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public SpectralSetupParameters getSpectralSetupParameters() {
        return this.spectralSetupParameters;
    }

    @Override
    public Frequency getInputFrequency() {
        return this.inputFrequency;
    }
}

