/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.ObservingGroupT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BOWithSpecificName;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.ObservingGroupData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class ObservingGroup
extends ObservingGroupData
implements BOWithSpecificName,
ObsUnitSetComponent {
    private final Log.Logger logger = Log.logger((Object)this);
    private static int nameIndex = 1;

    public ObservingGroup(ObservingGroupT observingGroupT) {
        super(observingGroupT);
    }

    public String updateName() {
        Object object = this.getName();
        if (object == null || object == "") {
            object = "Observing Group " + nameIndex++;
            this.setName((String)object);
        }
        return object;
    }

    public SchedBlock getSchedBlock() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            String string = "Parent SB is not set to Target instance (Target@" + this.hashCode() + ")";
            new RuntimeException(string).printStackTrace();
            this.logger.warning(string);
        }
        return schedBlock;
    }

    public boolean isTargetInGroup(Target target) {
        for (int i = 0; i < this.getOrderedTargetCount(); ++i) {
            if (target.getEntityPartId() != this.getOrderedTarget(i).getTarget().getEntityPartId()) continue;
            return true;
        }
        return false;
    }

    public void refreshIndices() {
        for (int i = 0; i < this.getOrderedTargetCount(); ++i) {
            this.getOrderedTarget(i).setIndex(i + 1);
        }
    }

    public OrderedTarget createOrderedTarget() {
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        this.addOrderedTarget(orderedTarget);
        int n = this.getOrderedTargetCount();
        orderedTarget.setIndex(n);
        return orderedTarget;
    }

    public OrderedTarget createOrderedTarget(int n) {
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        try {
            this.addOrderedTarget(n, orderedTarget);
            this.refreshIndices();
            return orderedTarget;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void deleteOrderedTarget(int n) {
        this.removeOrderedTarget(this.getOrderedTarget(n));
        this.refreshIndices();
    }

    public void deleteOrderedTarget(String string) {
        for (int i = 0; i < this.getOrderedTargetCount(); ++i) {
            Target target = this.getOrderedTarget(i).getTarget();
            if (target.getEntityPartId() != string) continue;
            this.removeOrderedTarget(this.getOrderedTarget(i));
            this.refreshIndices();
            break;
        }
    }

    public void moveOrderedTargetUpOneRow(int n) {
        OrderedTarget[] orderedTargetArray = this.getOrderedTarget();
        try {
            OrderedTarget orderedTarget;
            OrderedTarget orderedTarget2 = orderedTargetArray[n - 1];
            orderedTargetArray[n - 1] = orderedTarget = orderedTargetArray[n];
            orderedTargetArray[n] = orderedTarget2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.setOrderedTarget(orderedTargetArray);
        this.refreshIndices();
    }

    public void moveOrderedTargetDownOneRow(int n) {
        OrderedTarget[] orderedTargetArray = this.getOrderedTarget();
        try {
            OrderedTarget orderedTarget;
            OrderedTarget orderedTarget2 = orderedTargetArray[n];
            orderedTargetArray[n] = orderedTarget = orderedTargetArray[n + 1];
            orderedTargetArray[n + 1] = orderedTarget2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.setOrderedTarget(orderedTargetArray);
        this.refreshIndices();
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        String string = this.getName();
        if (string == null || string == "") {
            return "Group " + this.getIndex();
        }
        return "Group " + this.getIndex() + " : " + string;
    }

    @Override
    public ObsUnitSet getContainingObsUnitSet() {
        ObsUnitSetComponent obsUnitSetComponent = (ObsUnitSetComponent)this.getParent();
        return obsUnitSetComponent.getContainingObsUnitSet();
    }

    public List<Target> getAllOrderedTargets(Optional<Predicate<Target>> optional) {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (OrderedTarget orderedTarget : this.getOrderedTarget()) {
            Target target2 = orderedTarget.getTarget();
            if (!optional.orElse(target -> true).test(target2)) continue;
            arrayList.add(target2);
        }
        return arrayList;
    }
}

