/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.BOUtilities;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.OusCollection;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.ResourceCollection;
import alma.obsprep.bo.SubSBCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.ControlBlockData;
import alma.obsprep.bo.obsproject.data.ObsUnitSetData;
import alma.obsprep.bo.obsproject.data.OpticalPointingScienceGoalData;
import alma.obsprep.bo.obsproject.data.ScienceGoalData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.SchedBlockData;
import alma.obsprep.bo.schedblock.data.SpectralSpecData;
import alma.obsprep.bo.schedblock.data.SquareLawSetupData;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.data.TimeData;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.EnumSet;
import lombok.NonNull;

public class AddPerformer
extends Performer {
    private static DialogId DIALOG_ADD = new DialogId("Add.Confirm");

    public AddPerformer(AddInteractor addInteractor) {
        super(addInteractor);
    }

    @Override
    public void perform() {
        AddInteractor addInteractor = (AddInteractor)this.getGui();
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (!this.confirmAdd(businessObject)) {
            return;
        }
        Object object = null;
        AddInteractor.ObjectType objectType = addInteractor.whatType();
        switch (objectType) {
            case SCHEDBLOCK: {
                object = this.performAddSB(addInteractor);
                break;
            }
            case OBSUNITSET: {
                object = this.performAddOUS(addInteractor);
                break;
            }
            case OBSERVINGGROUP: {
                object = this.performAddObservingGroup(addInteractor);
                break;
            }
            case TARGET: {
                object = this.performAddTarget(addInteractor);
                break;
            }
            case FIELDSOURCE: {
                object = this.performAddFieldSource(addInteractor);
                break;
            }
            case BLSPECTRALSPEC: 
            case ACASPECTRALSPEC: 
            case SQUARELAWSPECTRALSPEC: {
                object = this.performAddSpectralSpec(addInteractor);
                break;
            }
            case OPTICALCAMERASPEC: {
                object = this.performAddOpticalCameraSpec(addInteractor);
                break;
            }
            case SCIENCEPARAMETERS: 
            case PHASECALPARAMETERS: 
            case POINTINGCALPARAMETERS: 
            case AMPLITUDECALPARAMETERS: 
            case POLARIZATIONCALPARAMETERS: 
            case FOCUSCALPARAMETERS: 
            case ATMOSPHERICCALPARAMETERS: 
            case DELAYCALPARAMETERS: 
            case CHECKSOURCECALPARAMETERS: 
            case DGCREFERENCECALPARAMETERS: 
            case DGCSCIENCECALPARAMETERS: 
            case SIDEBANDRATIOCALPARAMETERS: 
            case BANDPASSCALPARAMETERS: 
            case OPTICALPOINTINGPARAMETERS: 
            case RADIOMETRICPOINTINGPARAMETERS: 
            case HOLOGRAPHYPARAMETERS: {
                object = this.performAddObservingParameters(addInteractor);
                break;
            }
            case OPTICALPOINTINGWIZARD: {
                object = this.performAddOpticalPointingScienceGoal(addInteractor);
                break;
            }
            case SCIENCEGOAL: {
                object = this.performAddScienceGoal(addInteractor);
                break;
            }
            case CALIBRATORSURVEYWIZARD: {
                object = this.performAddCalibratorSurveyGoal(addInteractor);
                break;
            }
            case RADIOMETRICPOINTINGWIZARD: {
                object = this.performAddRadiometricPointingGoal(addInteractor);
                break;
            }
            case BASELINECALIBRATIONWIZARD: {
                object = this.performAddBaselineCalibrationGoal(addInteractor);
                break;
            }
            case HOLOGRAPHYSETUP: {
                object = this.performAddHolographySetup(addInteractor);
                break;
            }
            case ASTROHOLOGRAPHYSETUP: {
                object = this.performAddAstroHolographySetup(addInteractor);
                break;
            }
            case PHASEISCIENCEGOAL: {
                object = this.performAddPhaseIScienceGoal(addInteractor);
                break;
            }
            default: {
                throw new RuntimeException("Invalid Business Object type: " + addInteractor.whatType());
            }
        }
        if (object != null) {
            addInteractor.updateDisplay(businessObject, (BusinessObject)object, -1);
        }
        ActionLog.performed(new Object[]{"Add", objectType, "to", businessObject});
    }

    private ObsUnitSet performAddOUS(AddInteractor addInteractor) {
        ObsUnitSet obsUnitSet = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject.getClass().equals(ObsUnitSet.class)) {
            ObsUnitSet obsUnitSet2 = (ObsUnitSet)businessObject;
            obsUnitSet = ObsUnitSetData.createObsUnitSet();
            obsUnitSet2.addObsUnitSet(obsUnitSet);
            return obsUnitSet;
        }
        if (businessObject.getClass().equals(ObsProgram.class)) {
            ObsProgram obsProgram = (ObsProgram)businessObject;
            obsUnitSet = ObsUnitSetData.createObsUnitSet();
            obsProgram.getObsPlan().addObsUnitSet(obsUnitSet);
            return obsUnitSet;
        }
        if (businessObject.getClass().equals(OusCollection.class)) {
            ObsProgram obsProgram = ((OusCollection)businessObject).getObsProgram();
            obsUnitSet = ObsUnitSetData.createObsUnitSet();
            obsProgram.getObsPlan().addObsUnitSet(obsUnitSet);
            return obsUnitSet;
        }
        addInteractor.error("Cannot add an ObsUnitSet to " + businessObject.getNameOrDefault());
        return null;
    }

    private SchedBlock performAddSB(AddInteractor addInteractor) {
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject.getClass().equals(ObsUnitSet.class)) {
            ObsUnitSet obsUnitSet = (ObsUnitSet)businessObject;
            schedBlock = SchedBlockData.createSchedBlock();
            obsUnitSet.addSchedBlock(schedBlock);
            return schedBlock;
        }
        if (businessObject.getClass().equals(ObsProgram.class)) {
            ObsProgram obsProgram = (ObsProgram)businessObject;
            ObsUnitSet obsUnitSet = obsProgram.getObsPlan();
            schedBlock = SchedBlockData.createSchedBlock();
            schedBlock = SchedBlockData.createSchedBlock();
            obsUnitSet.addSchedBlock(schedBlock);
            return schedBlock;
        }
        addInteractor.error("Cannot add a Scheduling Block to " + businessObject.getNameOrDefault());
        return null;
    }

    private OpticalPointingScienceGoal performAddOpticalPointingScienceGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        OpticalPointingScienceGoal opticalPointingScienceGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            opticalPointingScienceGoal = OpticalPointingScienceGoalData.createOpticalPointingScienceGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)opticalPointingScienceGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)opticalPointingScienceGoal, -1);
        }
        catch (ClassCastException classCastException) {
            addInteractor.error("Cannot add an optical pointing wizard parameters to " + businessObject.getNameOrDefault());
        }
        return null;
    }

    private HolographyParameters performAddHolographySetup(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (!(businessObject instanceof ObsProgram)) {
            String string = "Unexpected node for Holography Setup : " + businessObject.getClass().getSimpleName();
            Log.logger((Object)this).warning(string);
            return null;
        }
        HolographyParameters holographyParameters = null;
        ObsUnitSet obsUnitSet = this.performAddOUS(addInteractor);
        if (obsUnitSet != null) {
            SchedBlock schedBlock = SchedBlockData.createSchedBlock();
            ObservingModeExpert observingModeExpert = ObservingModeExpert.getInstance();
            schedBlock.setModeName("Tower Holography");
            SBGenerationContext sBGenerationContext = new SBGenerationContext();
            sBGenerationContext.setSBType(SBGeneratorTemplate.SchedBlockType.SCHEDBLOCKTYPEUNKNOWN).setSBGenerationSchema(EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.OBSERVATORYGOAL));
            schedBlock.setSbGenerationContext(sBGenerationContext);
            observingModeExpert.updateSchedBlock(schedBlock, "Tower Holography");
            schedBlock.getSchedBlockControl().setIndefiniteRepeat(true);
            schedBlock.getSchedBlockControl().setSBMaximumTime(Time.createTimeSec(1800.0));
            schedBlock.getObsUnitControl().setMaximumTime(Time.createTimeSec(1800.0));
            schedBlock.setName("Holography");
            obsUnitSet.addSchedBlock(schedBlock);
            holographyParameters = schedBlock.createHolographyParameters();
            Frequency frequency = holographyParameters.getFrequency();
            schedBlock.getSchedulingConstraints().setRepresentativeFrequency(frequency);
        }
        return holographyParameters;
    }

    private Target performAddAstroHolographySetup(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (!(businessObject instanceof ObsProgram)) {
            String string = "Unexpected node for Holography Setup : " + businessObject.getClass().getSimpleName();
            Log.logger((Object)this).warning(string);
            return null;
        }
        throw new RuntimeException("Astro-holography is no longer available (see ICT-2468)");
    }

    private ScienceGoal performAddCalibratorSurveyGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ObservatoryGoal observatoryGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            observatoryGoal = ObservatoryGoal.createCalibratorSurveyGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)observatoryGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)observatoryGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a calibrator survey wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private ScienceGoal performAddRadiometricPointingGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ObservatoryGoal observatoryGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            observatoryGoal = ObservatoryGoal.createRadiometricPointingGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)observatoryGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)observatoryGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a calibrator survey wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private ScienceGoal performAddBaselineCalibrationGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ObservatoryGoal observatoryGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            observatoryGoal = ObservatoryGoal.createBaselineCalibrationGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)observatoryGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)observatoryGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a calibrator survey wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private ScienceGoal performAddScienceGoal(@NonNull AddInteractor addInteractor) {
        if (addInteractor == null) {
            throw new NullPointerException("gui is marked non-null but is null");
        }
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ScienceGoal scienceGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            scienceGoal = ScienceGoalData.createScienceGoal();
            TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
            scienceGoal.setTargetParameters(targetParameters);
            ObsProposal obsProposal = ObservingToolController.getMyInstance().getPrimaryProject().getObsProposal();
            if (obsProposal.isPhasedArray()) {
                ObsProposalModel.setVLBIPassivePhasing(obsProposal);
            }
            if (obsProposal.isVLBIorPhasedArray()) {
                VLBIExpert.setToVLBIDefaultSpectralConfiguration(scienceGoal);
            }
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)scienceGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a single field wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private ScienceGoal performAddPhaseIScienceGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ScienceGoal scienceGoal = null;
        try {
            ObsProposal obsProposal;
            if (businessObject instanceof PhaseISciencePlanCollection) {
                obsProposal = ((PhaseISciencePlanCollection)businessObject).getObsProposal();
            } else if (businessObject instanceof ObsProposal) {
                obsProposal = (ObsProposal)businessObject;
            } else if (businessObject instanceof ObsProject) {
                obsProposal = ((ObsProject)businessObject).getObsProposal();
            } else {
                return null;
            }
            scienceGoal = ScienceGoalData.createScienceGoal();
            obsProposal.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
            if (obsProposal.isPhasedArray()) {
                ObsProposalModel.setVLBIPassivePhasing(obsProposal);
            }
            if (obsProposal.isVLBIorPhasedArray()) {
                VLBIExpert.setToVLBIDefaultSpectralConfiguration(scienceGoal);
            }
            addInteractor.updateDisplay((BusinessObject)obsProposal, (BusinessObject)scienceGoal, -1);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a single field wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private BusinessObject performAddObservingGroup(AddInteractor addInteractor) {
        ObservingGroup observingGroup = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            observingGroup = schedBlock.createObservingGroup();
        } else {
            addInteractor.error("Cannot add an Observing Group to " + businessObject.getNameOrDefault());
        }
        return observingGroup;
    }

    private BusinessObject performAddTarget(AddInteractor addInteractor) {
        Target target = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof TargetCollection) {
            TargetCollection targetCollection = (TargetCollection)businessObject;
            schedBlock = targetCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            target = schedBlock.createTarget();
        } else {
            addInteractor.error("Cannot add an Target to " + businessObject.getNameOrDefault());
        }
        return target;
    }

    private BusinessObject performAddFieldSource(AddInteractor addInteractor) {
        FieldSource fieldSource = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof FieldSourceCollection) {
            FieldSourceCollection fieldSourceCollection = (FieldSourceCollection)businessObject;
            schedBlock = fieldSourceCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            ResourceCollection resourceCollection = (ResourceCollection)businessObject;
            schedBlock = resourceCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            fieldSource = schedBlock.createFieldSource();
        } else {
            addInteractor.error("Cannot add an FieldSource to " + businessObject.getNameOrDefault());
        }
        return fieldSource;
    }

    private BusinessObject performAddSpectralSpec(AddInteractor addInteractor) {
        SubSBCollection subSBCollection;
        SpectralSpec spectralSpec = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof InstrumentSpecCollection) {
            subSBCollection = (InstrumentSpecCollection)businessObject;
            schedBlock = subSBCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            subSBCollection = (ResourceCollection)businessObject;
            schedBlock = subSBCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            int n = schedBlock.getSpectralSpecCount();
            switch (addInteractor.whatType()) {
                case ACASPECTRALSPEC: {
                    spectralSpec = schedBlock.createSpectralSpecWithACACorrelatorConfiguration();
                    schedBlock.getObsUnitControl().setArrayRequested(ControlBlockData.ARRAYREQUESTED_ACA);
                    break;
                }
                case BLSPECTRALSPEC: {
                    spectralSpec = schedBlock.createSpectralSpecWithBLCorrelatorConfiguration();
                    schedBlock.getObsUnitControl().setArrayRequested(ControlBlockData.ARRAYREQUESTED_TWELVE_M);
                    break;
                }
                case SQUARELAWSPECTRALSPEC: {
                    spectralSpec = SpectralSpecData.createSpectralSpec();
                    SquareLawSetup squareLawSetup = SquareLawSetupData.createSquareLawSetup();
                    squareLawSetup.setIntegrationDuration(TimeData.createTime((double)16.0, (String)TimeData.UNIT_MS));
                    spectralSpec.setSquareLawSetup(squareLawSetup);
                    schedBlock.addSpectralSpec(spectralSpec);
                    break;
                }
            }
            if (schedBlock.getSpectralSpecCount() == n) {
                spectralSpec = null;
            }
        } else {
            addInteractor.error("Cannot add an Spectral Spec to " + businessObject.getNameOrDefault());
        }
        return spectralSpec;
    }

    private BusinessObject performAddOpticalCameraSpec(AddInteractor addInteractor) {
        SubSBCollection subSBCollection;
        OpticalCameraSpec opticalCameraSpec = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof InstrumentSpecCollection) {
            subSBCollection = (InstrumentSpecCollection)businessObject;
            schedBlock = subSBCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            subSBCollection = (ResourceCollection)businessObject;
            schedBlock = subSBCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            int n = schedBlock.getOpticalCameraSpecCount();
            opticalCameraSpec = schedBlock.createOpticalCameraSpec();
            if (schedBlock.getOpticalCameraSpecCount() == n) {
                opticalCameraSpec = null;
            }
        } else {
            addInteractor.error("Cannot add an Optical Camera Spec to " + businessObject.getNameOrDefault());
        }
        return opticalCameraSpec;
    }

    private BusinessObject performAddObservingParameters(AddInteractor addInteractor) {
        SubSBCollection subSBCollection;
        Object object = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        AddInteractor.ObjectType objectType = addInteractor.whatType();
        if (businessObject instanceof ObservingParametersCollection) {
            subSBCollection = (ObservingParametersCollection)businessObject;
            schedBlock = subSBCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            subSBCollection = (ResourceCollection)businessObject;
            schedBlock = subSBCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            int n = schedBlock.getObservingParametersCount();
            switch (objectType) {
                case SCIENCEPARAMETERS: {
                    object = schedBlock.createScienceParameters();
                    break;
                }
                case PHASECALPARAMETERS: {
                    object = schedBlock.createPhaseCalParameters();
                    break;
                }
                case POINTINGCALPARAMETERS: {
                    object = schedBlock.createPointingCalParameters();
                    break;
                }
                case AMPLITUDECALPARAMETERS: {
                    object = schedBlock.createAmplitudeCalParameters();
                    break;
                }
                case POLARIZATIONCALPARAMETERS: {
                    object = schedBlock.createPolarizationCalParameters();
                    break;
                }
                case FOCUSCALPARAMETERS: {
                    object = schedBlock.createFocusCalParameters();
                    break;
                }
                case ATMOSPHERICCALPARAMETERS: {
                    object = schedBlock.createAtmosphericCalParameters();
                    break;
                }
                case DELAYCALPARAMETERS: {
                    object = schedBlock.createDelayCalParameters();
                    break;
                }
                case CHECKSOURCECALPARAMETERS: {
                    object = schedBlock.createCheckSourceCalParameters();
                    break;
                }
                case SIDEBANDRATIOCALPARAMETERS: {
                    object = schedBlock.createSidebandRatioCalParameters();
                    break;
                }
                case BANDPASSCALPARAMETERS: {
                    object = schedBlock.createBandpassCalParameters();
                    break;
                }
                case OPTICALPOINTINGPARAMETERS: {
                    object = schedBlock.createOpticalPointingParameters();
                    break;
                }
                case RADIOMETRICPOINTINGPARAMETERS: {
                    object = schedBlock.createRadiometricPointingParameters();
                    break;
                }
                case HOLOGRAPHYPARAMETERS: {
                    object = schedBlock.createHolographyParameters();
                    break;
                }
                case DGCREFERENCECALPARAMETERS: {
                    object = schedBlock.createDGCReferenceCalParameters();
                    break;
                }
                case DGCSCIENCECALPARAMETERS: {
                    object = schedBlock.createDGCScienceCalParameters();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Business Object type: " + objectType);
                }
            }
            if (schedBlock.getObservingParametersCount() == n) {
                object = null;
            }
        } else {
            addInteractor.error("Cannot add a " + objectType + " to " + businessObject.getNameOrDefault());
        }
        return object;
    }

    private boolean confirmAdd(BusinessObject businessObject) {
        AbstractScienceGoal abstractScienceGoal = BOUtilities.findScienceGoal(businessObject);
        if (abstractScienceGoal == null) {
            return true;
        }
        String string = "";
        string = abstractScienceGoal.getObsUnitSet() == businessObject ? "" : "part of ";
        String string2 = String.format("<html>Do you want to add an object into <br><br>&nbsp;&nbsp;&nbsp;%s?<br><br><strong>Note</strong>: it is %sthe ObsUnitSet generated from the Science Goal:<br><br>&nbsp;&nbsp;&nbsp;%s.<br><br></html>", businessObject.toTreeString(1, false, false), string, abstractScienceGoal.toTreeString(1, false, false));
        return GUIUtilities.confirm(DIALOG_ADD, string2);
    }
}

