/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.ValueUnitPairCellRenderer;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.obsproject.GoalTargetPropertiesTableModel;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.VelocityEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.GoalTargetParametersModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalTargetParametersModel;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ObservatoryGoalTargetParametersEditor
extends EditorWithGridBagLayout
implements TableModelListener,
ListSelectionListener {
    public static FieldID CANCEL_BUTTON_FID = new FieldID("ObservatoryGoalTargetParametersEditor Cancel button FID");
    public static FieldID DONE_BUTTON_FID = new FieldID("ObservatoryGoalTargetParametersEditor OK button FID");
    private JButton addPropertyButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton doneButton;
    private JLabel helpLabel;
    private JPanel okButtonPanel;
    private JPanel panel;
    private JLabel propertiesLabel;
    private JScrollPane propertiesScrollPane;
    private JTable propertiesTable;
    private JButton removePropertyButton;
    private JButton resolveSourceButton;
    private JLabel sourceNameLabel;
    private JTextField sourceNameTextField;
    private JLabel velocityLabel;
    private VelocityEditor velocityEditor;
    private SkyCoordsEditor skyCoordsEditor;
    private final ObservatoryGoalTargetParametersModel parametersModel;
    private final GoalTargetPropertiesTableModel propertiesTableModel = new GoalTargetPropertiesTableModel();

    public ObservatoryGoalTargetParametersEditor(ObservatoryGoalTargetParametersModel observatoryGoalTargetParametersModel) {
        this.setModel(observatoryGoalTargetParametersModel);
        this.parametersModel = observatoryGoalTargetParametersModel;
        this.initTargetParametersPanel();
        this.build();
        observatoryGoalTargetParametersModel.publish();
    }

    @Override
    protected void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panel, gridBagConstraints);
    }

    @Override
    protected void build() {
        super.build("ObservatoryGoalTargetParametersEditor");
        this.propertiesTableModel.addTableModelListener(this);
        this.propertiesTable.getSelectionModel().addListSelectionListener(this);
    }

    public JButton getDoneButton() {
        return this.doneButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getResolveButton() {
        return this.resolveSourceButton;
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (GoalTargetParametersModel.CALIBRATION_TARGET_PROPERTIES.equals(fieldID)) {
            if (object != null) {
                CalibrationTargetProperties[] calibrationTargetPropertiesArray = (CalibrationTargetProperties[])object;
                this.propertiesTableModel.setCalibrationTargetProperties(calibrationTargetPropertiesArray);
            }
            this.setButtons();
        }
        super.update(fieldID, object);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (GoalTargetParametersModel.REMOVE_PROPERTY.equals(fieldID)) {
            ArrayList<CalibrationTargetProperties> arrayList = new ArrayList<CalibrationTargetProperties>();
            for (int n : this.propertiesTable.getSelectedRows()) {
                arrayList.add(this.propertiesTableModel.getCalibrationTargetPropertiesAt(n));
            }
            return arrayList;
        }
        return object;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            int n = tableModelEvent.getFirstRow();
            if (n != tableModelEvent.getLastRow()) {
                return;
            }
            CalibrationTargetProperties calibrationTargetProperties = this.propertiesTableModel.getCalibrationTargetPropertiesAt(n);
            this.parametersModel.setCalibrationTargetProperties(calibrationTargetProperties, n);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    private void setButtons() {
        int[] nArray = this.propertiesTable.getSelectedRows();
        if (nArray.length == 0) {
            this.removePropertyButton.setEnabled(false);
        } else {
            this.removePropertyButton.setEnabled(true);
        }
    }

    private void initTargetParametersPanel() {
        this.addPropertyButton = this.makeButton(GoalTargetParametersModel.ADD_PROPERTY, "Add Property", "Add calibrator property");
        this.buttonPanel = new JPanel();
        this.cancelButton = this.makeButton(CANCEL_BUTTON_FID, "Cancel", "Cancel target and return to target list editor");
        this.doneButton = this.makeButton(DONE_BUTTON_FID, "Done", "Accept source and return to target list editor");
        this.helpLabel = new JLabel();
        this.okButtonPanel = new JPanel();
        this.panel = new JPanel();
        this.propertiesLabel = new JLabel();
        this.propertiesScrollPane = new ScrollWhenFocusedPane();
        this.removePropertyButton = this.makeButton(GoalTargetParametersModel.REMOVE_PROPERTY, "Remove Selected", "Remove selected calibrator property");
        this.resolveSourceButton = this.makeButton(GoalTargetParametersModel.RESOLVE_SOURCE, "Resolve Source", "Resolve source name");
        this.skyCoordsEditor = this.makeSkyCoordsEditor(this.parametersModel.getSkyCoordsModel(), "Target Coordinates");
        this.sourceNameLabel = new JLabel();
        this.sourceNameTextField = this.makeTextField(GoalTargetParametersModel.SOURCE_NAME, true, "Target name");
        this.velocityLabel = new JLabel();
        this.velocityEditor = this.makeVelocityEditor(this.parametersModel.getVelocityModel(), "Target velocity");
        this.panel.setLayout(new GridBagLayout());
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.helpLabel.setIcon(Icons.help);
        this.helpLabel.setText("<html><p>Enter the source coordinates and velocity, or enter source name and click <i>Resolve Source</i> to find these details using SESAME.</p></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.helpLabel, gridBagConstraints);
        this.sourceNameLabel.setText("Source Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)this.sourceNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)this.sourceNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.resolveSourceButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.skyCoordsEditor, gridBagConstraints);
        this.velocityLabel.setText("Velocity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panel.add((Component)this.velocityLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.panel.add((Component)this.velocityEditor, gridBagConstraints);
        this.propertiesLabel.setText("Target Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)this.propertiesLabel, gridBagConstraints);
        this.propertiesTable = new Table(this.propertiesTableModel){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = this.getSelectedRow();
                super.tableChanged(tableModelEvent);
                if (n < this.getRowCount() && n >= 0) {
                    this.setRowSelectionInterval(n, n);
                }
            }
        };
        this.propertiesTable.getTableHeader().setReorderingAllowed(false);
        this.propertiesTable.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        this.propertiesTable.setDefaultEditor(Sensitivity.class, new ValueUnitPairCellEditor.SensitivityEditor());
        this.propertiesTable.setDefaultEditor(Angle.class, new ValueUnitPairCellEditor.AngleEditor());
        this.propertiesTable.setDefaultRenderer(AbstractDoubleWithUnit.class, new ValueUnitPairCellRenderer());
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTable.setColumnSelectionAllowed(false);
        this.propertiesTable.getSelectionModel().addListSelectionListener(this);
        this.propertiesTable.setToolTipText("The known properties of the source at the indicated frequencies");
        this.propertiesScrollPane.setViewportView(this.propertiesTable);
        this.propertiesScrollPane.setToolTipText("Flux measurements can be edited by clicking on a value in the table");
        this.propertiesTable.setModel(this.propertiesTableModel);
        this.propertiesScrollPane.setViewportView(this.propertiesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.propertiesScrollPane, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.addPropertyButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removePropertyButton)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addPropertyButton).addComponent(this.removePropertyButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.panel.add((Component)this.buttonPanel, gridBagConstraints);
        GroupLayout groupLayout2 = new GroupLayout(this.okButtonPanel);
        this.okButtonPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.doneButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.doneButton).addComponent(this.cancelButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(18, 12, 12, 12);
        this.panel.add((Component)this.okButtonPanel, gridBagConstraints);
        this.addPropertyButton.setName("ObservatoryGoalTargetParametersEditor.addPropertyButton");
        this.buttonPanel.setName("ObservatoryGoalTargetParametersEditor.buttonPanel");
        this.cancelButton.setName("ObservatoryGoalTargetParametersEditor.cancelButton");
        this.doneButton.setName("ObservatoryGoalTargetParametersEditor.doneButton");
        this.helpLabel.setName("ObservatoryGoalTargetParametersEditor.helpLabel");
        this.okButtonPanel.setName("ObservatoryGoalTargetParametersEditor.okButtonPanel");
        this.panel.setName("ObservatoryGoalTargetParametersEditor.panel");
        this.propertiesLabel.setName("ObservatoryGoalTargetParametersEditor.propertiesLabel");
        this.propertiesScrollPane.setName("ObservatoryGoalTargetParametersEditor.propertiesScrollPane");
        this.propertiesTable.setName("ObservatoryGoalTargetParametersEditor.propertiesTable");
        this.removePropertyButton.setName("ObservatoryGoalTargetParametersEditor.removePropertyButton");
        this.resolveSourceButton.setName("ObservatoryGoalTargetParametersEditor.resolveSourceButton");
        this.skyCoordsEditor.setName("ObservatoryGoalTargetParametersEditor.skyCoordsEditor");
        this.sourceNameLabel.setName("ObservatoryGoalTargetParametersEditor.sourceNameLabel");
        this.sourceNameTextField.setName("ObservatoryGoalTargetParametersEditor.sourceNameTextField");
        this.velocityEditor.setName("ObservatoryGoalTargetParametersEditor.velocityEditor");
        this.velocityLabel.setName("ObservatoryGoalTargetParametersEditor.velocityLabel");
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        ObservatoryGoalTargetParameters observatoryGoalTargetParameters = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
        observatoryGoalTargetParameters.addCalibrationTargetProperties(CalibrationTargetProperties.createCalibrationTargetProperties(1.0, 2.0));
        observatoryGoalTargetParameters.addCalibrationTargetProperties(CalibrationTargetProperties.createCalibrationTargetProperties(2.0, 3.0));
        final ObservatoryGoalTargetParametersModel observatoryGoalTargetParametersModel = new ObservatoryGoalTargetParametersModel(observatoryGoalTargetParameters);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
                }
                ObservatoryGoalTargetParametersEditor observatoryGoalTargetParametersEditor = new ObservatoryGoalTargetParametersEditor(observatoryGoalTargetParametersModel);
                JFrame jFrame = new JFrame("ObservatoryGoalTargetParametersEditor");
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().add(observatoryGoalTargetParametersEditor);
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

