/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.util.GUIUtilities;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

class OpenDuplicationsURLAction
implements ActionListener {
    public static final DialogId browserErrorDialog = new DialogId("Editor.UnexpectedError");

    OpenDuplicationsURLAction() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Desktop desktop = null;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            URI uRI = null;
            String string = actionEvent.getActionCommand();
            try {
                uRI = new URI(string);
                desktop.browse(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.logger((Object)this).warning("Got a bad URI " + string + "(" + uRISyntaxException.getMessage() + ")");
                String string2 = "Unable to load URL " + string + " in desktop browser.\nPlease check your desktop browser configuration.";
                GUIUtilities.warning(browserErrorDialog, string2);
            }
            catch (IOException iOException) {
                Log.logger((Object)this).warning("Failed to launch desktop web browser for URI " + uRI.toString() + "(" + iOException.getMessage() + ")");
                String string3 = "Unable to load URL " + string + " in desktop browser.\nPlease check your desktop browser configuration.";
                GUIUtilities.warning(browserErrorDialog, string3);
            }
        }
    }
}

