/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.PositiveVerifier;
import alma.obsprep.ot.boEditors.ValueUnitPairVerifier;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.editors.valuetypes.CoordsTypeEnum;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.RectangleModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RectangleEditor
extends EditorWithGridBagLayout {
    public static final FieldID NYQUIST_FID = new FieldID("RectangleEditor.Nyquist");
    public static final FieldID NPOINTINGS12M_FID = new FieldID("RectangleEditor.12mPointings");
    public static final FieldID NPOINTINGS7M_FID = new FieldID("RectangleEditor.7mPointings");
    public static final FieldID EXPORT_POINTINGS_FID = new FieldID("RectangleEditor.ExportPointings");
    public static final FieldID ACA_ENABLED_FID = new FieldID("RectangleEditor.ACAenabled");
    public static final FieldID SPACINGEDITABLE_FID = new FieldID("RectangleEditor.SpacingEditable");
    private CoordsEditor coordsEditor = null;
    private ValueUnitPairEditor longEditor = null;
    private ValueUnitPairEditor shortEditor = null;
    private ValueUnitPairEditor paLongEditor = null;
    private ValueUnitPairEditor spacingEditor = null;
    private JTextField acaTextField;
    private JLabel acaLabel;

    public RectangleEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public RectangleModel getModel() {
        return (RectangleModel)super.getModel();
    }

    @Override
    protected void build() {
        super.build("Rectangle");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = null;
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.coordsEditor = new CoordsEditor(false, this.getModel().getCoordsModel());
        JLabel jLabel = new JLabel("<html>Field Center<br>Coordinates</html>");
        jLabel.setName("RectangleEditor.FieldCenterCoordsLabel");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, jLabel, (JComponent)this.coordsEditor);
        this.registerSubView(this.coordsEditor);
        this.longEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getLongModel(), "p length", "Length of the 'p' side of the rectangle");
        this.longEditor.getUnits().setName("RectangleEditor.PLenUnitCombo");
        this.longEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(this.longEditor));
        this.registerSubView(this.longEditor);
        this.shortEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getShortModel(), "q length", "Length of the 'q' side of the rectangle");
        this.shortEditor.getUnits().setName("RectangleEditor.QLenUnitCombo");
        this.shortEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(this.shortEditor));
        this.registerSubView(this.shortEditor);
        this.paLongEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getPALongModel(), "Position Angle", "The position angle of the rectangle");
        this.paLongEditor.getUnits().setName("RectangleEditor.PosAngleUnitCombo");
        this.paLongEditor.setVerifier("FOCUSLOST_VERIFIER", new ValueUnitPairVerifier(this.paLongEditor, -1.7976931348623157E308, (double)Double.MAX_VALUE));
        this.registerSubView(this.paLongEditor);
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fraction of antenna beamsize", "fraction of main beam");
        this.spacingEditor = new UserUnitValueUnitPairEditor(this.getModel().getSpacingModel(), hashMap);
        this.spacingEditor.getUnits().setName("RectangleEditor.SpacingUnitCombo");
        this.spacingEditor.setToolTipText("Spacing between the individual pointings, the default is ~0.510929 (=1/(1.13 * sqrt(3)))");
        this.spacingEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(this.spacingEditor));
        componentCollection.remember(this.makeLabel("Spacing"));
        componentCollection.remember(this.spacingEditor);
        componentCollection.remember(this.makeButton(NYQUIST_FID, "Reset to Nyquist", "Reset the spacing value to nyquist, which is 1/(1.13 *sqrt(3))"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.registerSubView(this.spacingEditor);
        Box box = Box.createHorizontalBox();
        box.add(this.makeLabel("12m Array "));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.makeTextField(NPOINTINGS12M_FID, 5, false, "Number of pointings in this rectangle."));
        box.add(Box.createHorizontalStrut(20));
        this.acaLabel = this.makeLabel("7m Array ");
        box.add(this.acaLabel);
        box.add(Box.createHorizontalStrut(5));
        this.acaTextField = this.makeTextField(NPOINTINGS7M_FID, 5, false, "Number of pointings in this rectangle.");
        box.add(this.acaTextField);
        box.add(Box.createHorizontalStrut(20));
        box.add(this.makeButton(EXPORT_POINTINGS_FID, "Export", "Export the pointings for use in external applications"));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "#Pointings", (JComponent)box);
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.addGroup(jPanel, string);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == NYQUIST_FID) {
            return;
        }
        if (ACA_ENABLED_FID.equals(fieldID) && object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            this.acaLabel.setVisible(bl);
            this.acaTextField.setVisible(bl);
        }
        if (fieldID == SPACINGEDITABLE_FID) {
            boolean bl = (Boolean)object;
            this.spacingEditor.setEnabled(bl);
        }
        if (fieldID == AbstractTargetEditor.FID_NONSIDEREALMOTION) {
            boolean bl = (Boolean)object;
            OTButtonGroup oTButtonGroup = this.coordsEditor.getCoordsTypeComponents();
            if (bl) {
                this.coordsEditor.update(CoordsEditor.FID_COORDS_TYPE, CoordsTypeEnum.Relative.getUILabel());
                oTButtonGroup.setEnabled(false);
            } else {
                oTButtonGroup.setEnabled(true);
            }
        }
        super.update(fieldID, object);
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        return this.coordsEditor.getUserRestrictedEditableComponents();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        RectangleModel rectangleModel = new RectangleModel(null);
        RectangleEditor rectangleEditor = new RectangleEditor(rectangleModel);
        Rectangle rectangle = Rectangle.createRectangle();
        rectangleModel.setDocument(rectangle);
        EditorWithGridBagLayout.runTestApp(rectangleEditor);
    }
}

