/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.editors.misc.DecValueCellEditor;
import alma.obsprep.ot.editors.misc.RAValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.schedblock.ObservingGroupSelectTargetsTableModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ObservingGroupSelectTargetsTable
extends Table {
    public static final int TABLE_WIDTH = 530;
    public static final int TABLE_HEIGHT = 250;

    public ObservingGroupSelectTargetsTable(TableModel tableModel) {
        super(tableModel);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("Targets to be executed in this group");
        Dimension dimension = new Dimension(530, 250);
        this.setPreferredScrollableViewportSize(dimension);
        this.setFillsViewportHeight(true);
        this.setupCellEditorAndRenderer();
        this.listenToTableSelections();
    }

    private void listenToTableSelections() {
        this.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            try {
                ObservingToolController.getMyInstance().getGui().refreshCrossHighlight();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    private void setupCellEditorAndRenderer() {
        this.setDefaultEditor(Double.class, new ValueCellEditor.Double());
        this.setDefaultEditor(Integer.class, new ValueCellEditor.Integer());
        this.setDefaultEditor(Longitude.class, new RAValueCellEditor());
        this.setDefaultEditor(Latitude.class, new DecValueCellEditor());
        this.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        TableColumn tableColumn = this.getColumnModel().getColumn(7);
        tableColumn.setCellRenderer(new RadioButtonRenderer());
        tableColumn.setCellEditor(new RadioButtonEditor(new JCheckBox()));
        this.setDefaultRenderer(Object.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Integer.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Double.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Frequency.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Object object2 = "";
                String string = "";
                if (object != null) {
                    try {
                        Frequency frequency = (Frequency)((Object)object);
                        string = frequency.toString();
                        object2 = string.substring(0, string.indexOf(46) + 2);
                        object2 = (String)object2 + string.substring(string.indexOf(32));
                    }
                    catch (Exception exception) {
                        object2 = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
            }
        });
        this.setDefaultRenderer(Longitude.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Longitude longitude = (Longitude)((Object)object);
                        string = longitude.toHHMMSS();
                        string = string.substring(0, string.indexOf(46));
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this.setDefaultRenderer(Latitude.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Latitude latitude = (Latitude)((Object)object);
                        string = latitude.toDDMMSS();
                        string = string.substring(0, string.indexOf(46));
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
    }

    public ObservingGroupSelectTargetsTableModel getMyModel() {
        return (ObservingGroupSelectTargetsTableModel)this.getModel();
    }

    public class MyTableEditorCellRenderer
    extends DefaultTableCellRenderer {
        private final ObservingGroupSelectTargetsTableModel model;

        public MyTableEditorCellRenderer(ObservingGroupSelectTargetsTable observingGroupSelectTargetsTable2) {
            this.model = (ObservingGroupSelectTargetsTableModel)observingGroupSelectTargetsTable2.getModel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n >= this.model.getRowCount()) {
                return this;
            }
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            return this;
        }
    }

    private class RadioButtonRenderer
    implements TableCellRenderer {
        public final JRadioButton btn = new JRadioButton();

        private RadioButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Target target;
            if (object == null) {
                return null;
            }
            ObservingGroupSelectTargetsTableModel observingGroupSelectTargetsTableModel = ObservingGroupSelectTargetsTable.this.getMyModel();
            if (observingGroupSelectTargetsTableModel != null && !(target = ObservingGroupSelectTargetsTable.this.getMyModel().getOrderedTargetAtRow(n).getTarget()).hasScienceParameters()) {
                return null;
            }
            if (((Boolean)object).booleanValue()) {
                this.btn.setSelected(true);
            } else {
                this.btn.setSelected(false);
            }
            if (jTable.getSelectedRow() == n) {
                this.btn.setForeground(jTable.getSelectionForeground());
                this.btn.setBackground(jTable.getSelectionBackground());
            } else {
                this.btn.setForeground(jTable.getForeground());
                this.btn.setBackground(jTable.getBackground());
            }
            return this.btn;
        }
    }

    private static class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        public final JRadioButton btn = new JRadioButton();

        public RadioButtonEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            this.btn.addItemListener(this);
            if (((Boolean)object).booleanValue()) {
                this.btn.setSelected(true);
            } else {
                this.btn.setSelected(false);
            }
            return this.btn;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.btn.isSelected()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            super.fireEditingStopped();
        }
    }
}

