/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.services.experts.spectralline.gui.UnitFormat;
import alma.obsprep.util.Convert;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ResolverTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5547402349796697912L;
    private final List<Resolver> results = new ArrayList<Resolver>();

    public List<Resolver> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public void setResults(Collection<Resolver> collection) {
        this.results.clear();
        this.results.addAll(collection);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Name / Alias";
            }
            case 1: {
                return "RA";
            }
            case 2: {
                return "Dec";
            }
            case 3: {
                return "RA";
            }
            case 4: {
                return "Dec";
            }
            case 5: {
                return "Velocity";
            }
        }
        throw new IllegalArgumentException("Unhandled column");
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Resolver resolver = this.results.get(n);
        switch (n2) {
            case 0: {
                String string = resolver.getName();
                return string == null ? "" : string;
            }
            case 1: {
                String string;
                double d = resolver.getRa();
                try {
                    string = d == Resolver.NODATA ? "" : Convert.degToHHMMSS(d);
                }
                catch (OutOfRangeException outOfRangeException) {
                    string = "";
                }
                catch (InvalidCoordException invalidCoordException) {
                    string = "";
                }
                return string;
            }
            case 2: {
                String string;
                double d = resolver.getDec();
                try {
                    string = d == Resolver.NODATA ? "" : Convert.degToDDMMSS(d);
                }
                catch (OutOfRangeException outOfRangeException) {
                    string = "";
                }
                catch (InvalidCoordException invalidCoordException) {
                    string = "";
                }
                return string;
            }
            case 3: {
                double d = resolver.getProperMotionRa();
                String string = d == Resolver.NODATA ? "" : UnitFormat.properMotion().format(d);
                return string;
            }
            case 4: {
                double d = resolver.getProperMotionDec();
                String string = d == Resolver.NODATA ? "" : UnitFormat.properMotion().format(d);
                return string;
            }
            case 5: {
                Velocity velocity = resolver.getSourceVelocity();
                String string = velocity == null ? "" : UnitFormat.velocity().format(velocity.getCenterVelocity().getContent() * 1000.0);
                return string;
            }
        }
        throw new IllegalArgumentException("Unhandled column requested from table model");
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Resolver get(int n) {
        if (n < this.results.size()) {
            return this.results.get(n);
        }
        return null;
    }
}

