/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.ExpectedPropertiesData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.EnabledJComboBoxRenderer;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.editors.schedblock.SolarSystemTargetAwareEditor;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.sciencegoals.AbstractTargetModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractTargetEditor
extends SolarSystemTargetAwareEditor {
    private static final long serialVersionUID = -7411788626895411018L;
    public static final FieldID FID_SOURCENAME = new FieldID("TargetEditor.sourceName");
    public static final FieldID FID_NONSIDEREALMOTION = new FieldID("TargetEditor.nonSiderealMotion");
    public static final FieldID FID_SOLARSYSTEMOBJECT = new FieldID("TargetEditor.solarSystemObject");
    public static final FieldID FID_SOURCEEPHEMERIS = new FieldID("TargetEditor.sourceEphemeris");
    public static final FieldID FID_SOURCEVELOCITY_VALUE = new FieldID("TargetEditor.sourceVelocity.value");
    public static final FieldID FID_SOURCEVELOCITY_UNIT = new FieldID("TargetEditor.sourceVelocity.unit");
    public static final FieldID FID_SOURCEVELOCITY_SYSTEM = new FieldID("TargetEditor.sourceVelocitySystem");
    public static final FieldID FID_SOURCEVELOCITY_DOPPLER = new FieldID("TargetEditor.sourceVelocityDoppler");
    public static final FieldID FID_SOURCEVELOCITY_REDSHIFT = new FieldID("TargetEditor.sourceVelocityRedshift");
    public static final FieldID FID_RESOLVENAME = new FieldID("TargetEditor.resolveName");
    public static final FieldID FID_RESOLVECANCEL = new FieldID("TargetEditor.resolveCancel");
    public static final FieldID FID_PEAKFLUXDENSITY_VALUE = new FieldID("TargetEditor.peakFluxDensity.value");
    public static final FieldID FID_PEAKFLUXDENSITY_UNIT = new FieldID("TargetEditor.peakFluxDensity.unit");
    public static final FieldID FID_PEAKLINEFLUXDENSITY_VALUE = new FieldID("TargetEditor.peakLineFluxDensity.value");
    public static final FieldID FID_PEAKLINEFLUXDENSITY_UNIT = new FieldID("TargetEditor.peakLineFluxDensity.unit");
    public static final FieldID FID_CONTINUUM_LINEAR_POLARIZATION = new FieldID("TargetEditor.continuumPolarizationPercentage");
    public static final FieldID FID_SPECTRALLINE_CIRCULAR_POLARIZATION = new FieldID("TargetEditor.spectralLineCircularLinePolarizationPercentage");
    public static final FieldID FID_CONTINUUM_CIRCULAR_POLARIZATION = new FieldID("TargetEditor.continuumCircularLinePolarizationPercentage");
    public static final FieldID FID_LINEWIDTH_VALUE = new FieldID("TargetEditor.linewidth.value");
    public static final FieldID FID_LINEWIDTH_UNIT = new FieldID("TargetEditor.linewidth.unit");
    public static final FieldID FID_LINE_POLARIZATION_PERCENTAGE = new FieldID("TargetEditor.desiredLinePolarizationPercentage");
    public static final FieldID FID_SUN_IS_SELECTABLE = new FieldID("TargetEditor.isSunSelectable");
    private static final FieldID FID_STANDARD_EXPECTED_PROPERTIES_PANEL = new FieldID("TargetEditor.stdPropertiesPanel");
    private static final FieldID FID_SOLAR_EXPECTED_PROPERTIES_PANEL = new FieldID("TargetEditor.solarPropertiesPanel");
    public static final FieldID FID_SOLAR_ACTIVITY = new FieldID("TargetEditor.solarActivity");
    public static FieldID FID_VLBI_PASSIVE_PHASING = new FieldID("TargetEditor.isVLBIPassivePhasing");
    private String groupType = "Source";
    private boolean collapse;
    private EnabledJComboBoxRenderer solarSystemComboboxRenderer;
    private SolarSystemComboModel<String> solarSystemComboModel;
    private DefaultListSelectionModel solarObjectListSelectionModel;
    private EditorWithGridBagLayout.ComponentCollection expectedPropertiesStandardComponents;
    private JPanel standardExpectedPropertiesPanel;
    private ImmutableList<JComponent> vlbiSpectralLineExpectedPropertiesComponents;

    public AbstractTargetEditor(Model model, boolean bl) {
        this.setModel(model);
        this.collapse = bl;
    }

    @Override
    protected void build() {
        super.build(this.groupType);
    }

    @Override
    protected boolean wantGlobalButtons() {
        return false;
    }

    protected abstract void addExtraComponents(JPanel var1, GridBagLayout var2, GridBagConstraints var3);

    protected JPanel createTargetPanel() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        Box box = Box.createHorizontalBox();
        JTextField jTextField = this.makeTextField(FID_SOURCENAME, "Allowed characters: a..zA..Z0..9-+_.");
        jTextField.setColumns(50);
        box.add(jTextField);
        box.add(this.makeButton(FID_RESOLVENAME, "Resolve", "Get source details from SIMBAD or NED"));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Source Name", (JComponent)box);
        box = Box.createHorizontalBox();
        box.add(this.makeCheckBox(FID_NONSIDEREALMOTION, "This should be checked if the source exhibits non-sidereal motion (planet, asteroid, comet, etc.)"));
        box.add(Box.createHorizontalGlue());
        box.add(this.makeLabel("Name of object "));
        String[] stringArray = FieldSource.getKnownSolarSystemObjectList();
        this.solarSystemComboModel = new SolarSystemComboModel<String>(stringArray);
        JComboBox jComboBox = this.makeComboBox(FID_SOLARSYSTEMOBJECT, stringArray, "<html>If the source is a commonly-used solar system object then select its name from the list.<br>If the source is not listed then select he Ephemeris option and provide an ephemeris.</html>", null, Optional.of(this.solarSystemComboModel));
        this.solarObjectListSelectionModel = new DefaultListSelectionModel();
        this.solarSystemComboboxRenderer = new EnabledJComboBoxRenderer(this.solarObjectListSelectionModel);
        jComboBox.setRenderer(this.solarSystemComboboxRenderer);
        box.add(jComboBox);
        box.add(Box.createHorizontalGlue());
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Choose a Solar System Object?", (JComponent)box);
        this.addOTFileArea(jPanel, gridBagLayout, gridBagConstraints, FID_SOURCEEPHEMERIS, 300, 150, "", "Source ephemeris in HORIZONS format, see manual for details");
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addSolarSystemTargetAwareEditorComponents(jPanel, gridBagLayout, gridBagConstraints);
        this.addExtraComponents(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createStandardExpectedPropertiesPanel() {
        AbstractTargetModel abstractTargetModel = (AbstractTargetModel)this.getModel();
        this.standardExpectedPropertiesPanel = new JPanel();
        GridBagLayout gridBagLayout = this.createNewLayout(this.standardExpectedPropertiesPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        JCheckBox jCheckBox = this.makeCheckBox(FID_VLBI_PASSIVE_PHASING, "Passive phasing is required (science target < 0.5 Jy)", "Enable passive phasing for VLBI");
        this.addComponent(this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, jCheckBox);
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, abstractTargetModel.getExpectedPeakFluxDensity(), "Peak Continuum Flux Density per Synthesized Beam ", "<html><p>Expected peak flux density of source continuum for the <b>weakest</b> source component that you wish to detect</p></html>");
        valueUnitPairEditor.getInput().setName("AbstractTargetEditor.PeakContinuumFluxDensityPerBeamText");
        valueUnitPairEditor.getUnits().setName("AbstractTargetEditor.PeakContinuumFluxDensityPerBeamUnitCombo");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor));
        this.expectedPropertiesStandardComponents = new EditorWithGridBagLayout.ComponentCollection(this);
        JTextField jTextField = this.makeTextFieldWithDoubleVerifier(FID_CONTINUUM_LINEAR_POLARIZATION, "Expected linear polarization of the source in per cent", 0.0, 100.0);
        this.expectedPropertiesStandardComponents.remember(this.makeLabel("Continuum Linear Polarization"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jTextField.setColumns(8);
        jPanel.add(jTextField);
        jPanel.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel.add(this.makeLabel("per cent"));
        jPanel.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel.add(Box.createHorizontalGlue());
        this.expectedPropertiesStandardComponents.remember(jPanel);
        this.addComponentArray(this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, this.expectedPropertiesStandardComponents);
        this.expectedPropertiesStandardComponents = new EditorWithGridBagLayout.ComponentCollection(this);
        JTextField jTextField2 = this.makeTextFieldWithDoubleVerifier(FID_CONTINUUM_CIRCULAR_POLARIZATION, "Expected continuum circular polarization of the source in per cent", 0.0, 100.0);
        this.expectedPropertiesStandardComponents.remember(this.makeLabel("Continuum Circular Polarization"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        jTextField2.setColumns(8);
        jPanel2.add(jTextField2);
        jPanel2.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel2.add(this.makeLabel("per cent"));
        jPanel2.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel2.add(Box.createHorizontalGlue());
        this.expectedPropertiesStandardComponents.remember(jPanel2);
        this.addComponentArray(this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, this.expectedPropertiesStandardComponents);
        ValueUnitPairEditor valueUnitPairEditor2 = this.addValueUnitPair((JComponent)this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, abstractTargetModel.getExpectedPeakLineFluxDensity(), "Peak Line Flux Density per Synthesized Beam", "<html><p>Expected peak flux density of line emission, relative to the continuum for the <b>weakest</b> source component that you wish to detect</p></html>");
        valueUnitPairEditor2.getInput().setName("AbstractTargetEditor.PeakLineFluxDensityPerBeamText");
        valueUnitPairEditor2.getUnits().setName("AbstractTargetEditor.PeakLineFluxDensityPerBeamUnitCombo");
        valueUnitPairEditor2.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor2));
        this.expectedPropertiesStandardComponents = new EditorWithGridBagLayout.ComponentCollection(this);
        Object[] objectArray = UnitMap.getFrequencyUnits().getUnitsSorted();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        UserUnitValueUnitPairEditor userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(abstractTargetModel.getExpectedLineWidth());
        userUnitValueUnitPairEditor.getInput().setName("AbstractTargetEditor.LineWidthText");
        userUnitValueUnitPairEditor.getUnits().setName("AbstractTargetEditor.LineWidthUnitCombo");
        userUnitValueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(userUnitValueUnitPairEditor));
        this.register(userUnitValueUnitPairEditor, FID_LINEWIDTH_VALUE);
        this.registerSubView(userUnitValueUnitPairEditor);
        userUnitValueUnitPairEditor.setToolTipText("Expected width of the lines to be observed (FWHM)");
        JLabel jLabel = this.makeLabel("Line Width");
        this.expectedPropertiesStandardComponents.remember(jLabel);
        this.expectedPropertiesStandardComponents.remember(userUnitValueUnitPairEditor);
        this.vlbiSpectralLineExpectedPropertiesComponents = ImmutableList.of((Object)jLabel, (Object)userUnitValueUnitPairEditor, (Object)this.standardExpectedPropertiesPanel);
        this.addComponentArray(this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, this.expectedPropertiesStandardComponents);
        this.expectedPropertiesStandardComponents = new EditorWithGridBagLayout.ComponentCollection(this);
        this.expectedPropertiesStandardComponents.remember(this.makeLabel("Line Linear Polarization"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JTextField jTextField3 = this.makeTextFieldWithDoubleVerifier(FID_LINE_POLARIZATION_PERCENTAGE, "Expected polarization of the line in percent", 0.0, 100.0);
        jTextField3.setColumns(8);
        jPanel3.add(jTextField3);
        jPanel3.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel3.add(this.makeLabel("per cent"));
        jPanel3.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel3.add(Box.createHorizontalGlue());
        this.expectedPropertiesStandardComponents.remember(jPanel3);
        this.addComponentArray(this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, this.expectedPropertiesStandardComponents);
        this.expectedPropertiesStandardComponents = new EditorWithGridBagLayout.ComponentCollection(this);
        JTextField jTextField4 = this.makeTextFieldWithDoubleVerifier(FID_SPECTRALLINE_CIRCULAR_POLARIZATION, "Expected spectral line circular polarization of the source in per cent", 0.0, 100.0);
        this.expectedPropertiesStandardComponents.remember(this.makeLabel("Line Circular Polarization"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        jTextField4.setColumns(8);
        jPanel4.add(jTextField4);
        jPanel4.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel4.add(this.makeLabel("per cent"));
        jPanel4.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel4.add(Box.createHorizontalGlue());
        this.expectedPropertiesStandardComponents.remember(jPanel4);
        this.addComponentArray(this.standardExpectedPropertiesPanel, gridBagLayout, gridBagConstraints, this.expectedPropertiesStandardComponents);
        return this.standardExpectedPropertiesPanel;
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createTargetPanel();
        this.addGroup(jPanel, string);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        JPanel jPanel3 = this.createStandardExpectedPropertiesPanel();
        this.register(jPanel3, FID_STANDARD_EXPECTED_PROPERTIES_PANEL);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = this.createSolarExpectedPropertiesPanel();
        this.register(jPanel4, FID_SOLAR_EXPECTED_PROPERTIES_PANEL);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = this.addGroup(jPanel2, "Expected Source Properties");
        CSH.setHelpIDString((Component)jPanel5, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup-Expected Source Properties");
    }

    private JPanel createSolarExpectedPropertiesPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        String[] stringArray = new String[]{ExpectedPropertiesData.SOLARACTIVITYLEVEL_ACTIVESUN, ExpectedPropertiesData.SOLARACTIVITYLEVEL_QUIETSUN};
        OTButtonGroup oTButtonGroup = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, FID_SOLAR_ACTIVITY, "Solar activity level", "Solar activity level", stringArray, 3, 150);
        this.register(oTButtonGroup, FID_SOLAR_ACTIVITY);
        componentCollection.remember(oTButtonGroup);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        return jPanel;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        AbstractTargetModel abstractTargetModel = (AbstractTargetModel)this.getModel();
        if (fieldID.equals(FID_RESOLVENAME) || fieldID.equals(FID_RESOLVECANCEL)) {
            return;
        }
        if (fieldID.equals(FID_NONSIDEREALMOTION)) {
            boolean bl = (Boolean)object;
            this.retrieve(FID_RESOLVENAME).setVisible(!bl);
            ScienceGoalEditorViewEnum scienceGoalEditorViewEnum = null;
            try {
                TargetParameters targetParameters = (TargetParameters)abstractTargetModel.getDocument();
                scienceGoalEditorViewEnum = ScienceGoalEditorViewEnum.getScienceGoalSubview(targetParameters.getScienceGoal());
            }
            catch (ScienceGoalEditorViewEnum.UnableToDetermineSubviewException unableToDetermineSubviewException) {
                Log.logger(AbstractTargetEditor.class).info("Unable to determine subviews to be displayed" + unableToDetermineSubviewException.getMessage());
            }
            boolean bl2 = bl && (AbstractTargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject()) || AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject()));
            JComponent jComponent = this.retrieve(FID_SOURCEEPHEMERIS);
            if (jComponent != null) {
                this.setVisible(jComponent, bl2);
            }
            if ((jComponent = this.retrieve(FID_SOLARSYSTEMOBJECT)) != null) {
                this.setEnabled(jComponent, bl);
            }
            if (scienceGoalEditorViewEnum != null) {
                this.configureEditorForView(scienceGoalEditorViewEnum);
            }
            this.showExtraSolarSystemComponents(!bl, bl2);
            super.update(fieldID, object);
            return;
        }
        if (fieldID.equals(FID_SOLARSYSTEMOBJECT)) {
            JComponent jComponent = this.retrieve(FID_SOURCEEPHEMERIS);
            if (jComponent != null) {
                this.setVisible(jComponent, abstractTargetModel.getAbstractTarget().getNonSiderealMotion() && (AbstractTargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject()) || AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject())));
            }
            TargetParameters targetParameters = (TargetParameters)abstractTargetModel.getDocument();
            try {
                this.configureEditorForView(ScienceGoalEditorViewEnum.getScienceGoalSubview(targetParameters.getScienceGoal()));
            }
            catch (ScienceGoalEditorViewEnum.UnableToDetermineSubviewException unableToDetermineSubviewException) {
                Log.logger(AbstractTargetEditor.class).info("Unable to determine subviews to be displayed" + unableToDetermineSubviewException.getMessage());
            }
            super.update(fieldID, object);
            return;
        }
        if (fieldID.equals(FID_SUN_IS_SELECTABLE)) {
            boolean bl = (Boolean)object;
            this.setSunSelectableAsSolarSystemObject(bl);
        }
        super.update(fieldID, object);
    }

    private void setSunSelectableAsSolarSystemObject(boolean bl) {
        int n = -1;
        String[] stringArray = FieldSource.getKnownSolarSystemObjectList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(FieldSource.SOLARSYSTEMOBJECT_SUN)) continue;
            n = i;
            break;
        }
        assert (n > -1);
        this.solarObjectListSelectionModel.clearSelection();
        if (bl) {
            this.solarObjectListSelectionModel.setSelectionInterval(0, stringArray.length - 1);
        } else {
            this.solarObjectListSelectionModel.addSelectionInterval(0, n - 1);
            this.solarObjectListSelectionModel.addSelectionInterval(n + 1, stringArray.length - 1);
        }
        this.solarSystemComboModel.setSunSelectable(bl);
        if (!bl && this.solarSystemComboModel.getSelectedItem().equals(FieldSource.SOLARSYSTEMOBJECT_SUN)) {
            this.solarSystemComboModel.setSelectedItem(FieldSource.SOLARSYSTEMOBJECT_UNSPECIFIED);
        }
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.collapse) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    public void configureEditorForView(ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        boolean bl = ScienceGoalEditorViewEnum.SOLAR.equals((Object)scienceGoalEditorViewEnum);
        if (bl) {
            this.getComponent(FID_STANDARD_EXPECTED_PROPERTIES_PANEL).setVisible(false);
            this.getComponent(FID_SOLAR_EXPECTED_PROPERTIES_PANEL).setVisible(true);
        } else {
            this.getComponent(FID_STANDARD_EXPECTED_PROPERTIES_PANEL).setVisible(true);
            this.getComponent(FID_SOLAR_EXPECTED_PROPERTIES_PANEL).setVisible(false);
            this.reconfigureEditorForView(scienceGoalEditorViewEnum);
        }
    }

    private void reconfigureEditorForView(ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        Object object;
        Stream<Component> stream = Arrays.stream(this.standardExpectedPropertiesPanel.getComponents());
        boolean bl = scienceGoalEditorViewEnum == ScienceGoalEditorViewEnum.VLBI;
        stream.forEach(component -> component.setVisible(!bl));
        JComponent jComponent2 = this.getComponent(FID_VLBI_PASSIVE_PHASING);
        jComponent2.setVisible(bl);
        boolean bl2 = false;
        try {
            object = ObservingToolController.getMyInstance().getPrimaryProject().getObsProposal();
            bl2 = ((ObsProposal)((Object)object)).isPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(AbstractTargetEditor.class).warning("Unable to determine if VLBI Pulsar" + unknownEntityException.getMessage());
        }
        jComponent2.setEnabled(!bl2);
        object = ObservingToolController.getMyInstance().getGui().getEditorManager();
        SpectralSetupParametersModel spectralSetupParametersModel = (SpectralSetupParametersModel)((EditorManager)object).modelFor(SpectralSetupParameters.class);
        if (spectralSetupParametersModel != null && spectralSetupParametersModel.getDocument() != null && spectralSetupParametersModel.getSpectralType() != null && spectralSetupParametersModel.getSpectralType().equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE)) {
            this.vlbiSpectralLineExpectedPropertiesComponents.stream().forEach(jComponent -> jComponent.setVisible(true));
        }
    }

    private class SolarSystemComboModel<T>
    extends DefaultComboBoxModel<T> {
        boolean isSunSelectable;

        public void setSunSelectable(boolean bl) {
            this.isSunSelectable = bl;
        }

        SolarSystemComboModel(T[] TArray) {
            super(TArray);
            this.isSunSelectable = true;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (!this.isSunSelectable && object.toString().startsWith("Sun")) {
                return;
            }
            super.setSelectedItem(object);
        }
    }
}

