/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.RectangleEditor;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.models.sciencegoals.FieldModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FieldEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -5649208565099847718L;
    private PointingPatternEditor pointsEditor;
    private JPanel pointsPanel;
    private RectangleEditor rectangleEditor;
    private final String TITLE = "Field Center Coordinates";
    public static final FieldID FID_DOCUMENTLABEL = new FieldID("FieldEditor.documentLabel");

    public FieldEditor(Model model) {
        this.setModel(model);
        FieldModel fieldModel = this.getModel();
        this.pointsEditor = new PointingPatternEditor(fieldModel.getPointingPatternModel());
        this.rectangleEditor = new RectangleEditor(fieldModel.getRectangleModel());
        this.registerSubView(this.pointsEditor);
        this.registerSubView(this.rectangleEditor);
        this.build();
        model.publish();
    }

    public PointingPatternEditor getPointsEditor() {
        return this.pointsEditor;
    }

    public RectangleEditor getRectangleEditor() {
        return this.rectangleEditor;
    }

    @Override
    public FieldModel getModel() {
        return (FieldModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.register(this, FID_DOCUMENTLABEL);
        this.pointsPanel = this.addGroup(this.pointsEditor, "Field Center Coordinates");
        CSH.setHelpIDString((Component)this.pointsPanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup-Field Center Coordinates");
        this.addComponent(this.rectangleEditor);
        CSH.setHelpIDString((Component)this.rectangleEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup-Rectangle");
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(30);
        arrayList.addAll(this.pointsEditor.getUserRestrictedEditableComponents());
        arrayList.addAll(this.rectangleEditor.getUserRestrictedEditableComponents());
        return arrayList;
    }

    @Override
    protected void build() {
        super.build("Field");
    }

    @Override
    protected boolean wantGlobalButtons() {
        return false;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_DOCUMENTLABEL) {
            TargetParameters targetParameters = this.getModel().getTargetParameters();
            this.rectangleEditor.setVisible(targetParameters.isRectanglePattern());
            this.pointsPanel.setVisible(targetParameters.isPointingPattern());
            return;
        }
        super.update(fieldID, object);
    }
}

