/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.ScienceGoalData;
import alma.obsprep.bo.obsproject.data.SinglePointData;
import alma.obsprep.bo.obsproject.data.TargetParametersData;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NonStandardChoicesEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -3647513617315894590L;
    public static final FieldID FID_ANY_USER_CAL = new FieldID("NSC.any_user_cal");
    public static final FieldID FID_EXTRA_TIME = new FieldID("NSC.extra_time");
    public static final FieldID FID_HIGH_DATARATE = new FieldID("NSC.highDataRate");
    public static final FieldID FID_NON_STD_CONT = new FieldID("NSC.fid_non_std_cont");
    public static final FieldID FID_NYQUIST_SEP = new FieldID("NSC.mosaic_sep");
    public static final FieldID FID_SINGLE_POL = new FieldID("NSC.single_pol");
    public static final FieldID FID_TARGET_MAX_EL_LOW = new FieldID("NSC.target_max_el_low");
    public static final FieldID FID_TIME_CONSTRAINED = new FieldID("NSC.timeConstrained");
    public static final JLabel ANY_USER_CAL = new JLabel("* User-defined calibration");
    public static final JLabel EXTRA_TIME = new JLabel("* More time requested");
    String highdataratelabel = " High Data rate (> " + AlmaPolicies.getInstance().getWarning12mDataRateMBPS() + " MB /s)";
    public static final JLabel HIGH_DATARATE = new JLabel("* High Data rate (> 12 MB /s)");
    public static final JLabel NON_STD_CONT = new JLabel("* Non-standard continuum frequencies");
    public static final JLabel NYQUIST_SEP = new JLabel("* Non-Nyquist mosaic spacing");
    public static final JLabel SINGLE_POL = new JLabel("* Single Polarization");
    public static final JLabel TARGET_MAX_EL_LOW = new JLabel("* Low max elevation");
    public static final JLabel TIME_CONSTRAINED = new JLabel("* Time Constrained");
    private static final Map<FieldID, JComponent> nonStandardChoice = new HashMap<FieldID, JComponent>();
    private String groupType = "Technical Justification";

    public NonStandardChoicesEditor(Model model, boolean bl) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    public NonStandardChoicesEditor(Model model) {
        this(model, true);
    }

    @Override
    protected void build() {
        super.build(this.groupType);
    }

    @Override
    protected void addComponents(String string) {
        this.addNonCollapsingGroupNoHelp(this.createNonStandardChoicesSection(), "Non-standard choices");
    }

    public JPanel createNonStandardChoicesSection() {
        JPanel jPanel = this.createNewGroup();
        this.createNewLayout(jPanel);
        this.addHeading(jPanel, "Field setup:");
        this.addNonStandardChoice(jPanel, TARGET_MAX_EL_LOW, FID_TARGET_MAX_EL_LOW);
        this.addNonStandardChoice(jPanel, NYQUIST_SEP, FID_NYQUIST_SEP);
        this.addHeading(jPanel, "Spectral Setup:");
        this.addNonStandardChoice(jPanel, SINGLE_POL, FID_SINGLE_POL);
        this.addNonStandardChoice(jPanel, NON_STD_CONT, FID_NON_STD_CONT);
        this.addHeading(jPanel, "Calibration:");
        this.addNonStandardChoice(jPanel, ANY_USER_CAL, FID_ANY_USER_CAL);
        this.addHeading(jPanel, "Control and Performance:");
        this.addNonStandardChoice(jPanel, EXTRA_TIME, FID_EXTRA_TIME);
        this.addNonStandardChoice(jPanel, TIME_CONSTRAINED, FID_TIME_CONSTRAINED);
        this.addNonStandardChoice(jPanel, HIGH_DATARATE, FID_HIGH_DATARATE);
        return jPanel;
    }

    private void addHeading(JComponent jComponent, String string) {
        GridBagConstraints gridBagConstraints = this.getGridBagConstraints(true);
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel("<html><b>" + string + "</b></html>");
        jComponent.add((Component)jLabel, gridBagConstraints);
    }

    private void addNonStandardChoice(JComponent jComponent, JLabel jLabel, FieldID fieldID) {
        GridBagConstraints gridBagConstraints = this.getGridBagConstraints(true);
        jLabel.setHorizontalAlignment(2);
        gridBagConstraints = this.getGridBagConstraints(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jComponent.add((Component)jLabel, gridBagConstraints);
        nonStandardChoice.put(fieldID, jLabel);
        this.register(jLabel, fieldID);
    }

    private GridBagConstraints getGridBagConstraints(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = bl ? 1.0 : 0.0;
        return gridBagConstraints;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (nonStandardChoice.containsKey(fieldID)) {
            JComponent jComponent = nonStandardChoice.get(fieldID);
            Boolean bl = new Boolean(object.toString());
            jComponent.setVisible(bl);
            return;
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Non standard parameters Editor");
        jFrame.setDefaultCloseOperation(3);
        ScienceGoal scienceGoal = ScienceGoalData.createScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        performanceParameters.setIsTimeConstrained(true);
        TargetParameters targetParameters = TargetParametersData.createTargetParameters();
        SinglePoint singlePoint = SinglePointData.createSinglePoint();
        targetParameters.setSourceName("Target1");
        targetParameters.addField((Field)((Object)singlePoint));
        targetParameters.setType(TargetParametersData.TYPE_F_MULTIPLEPOINTS);
        scienceGoal.addTargetParameters(targetParameters);
        targetParameters = TargetParametersData.createTargetParameters();
        singlePoint = SinglePointData.createSinglePoint();
        targetParameters.setSourceName("Target2");
        targetParameters.addField((Field)((Object)singlePoint));
        targetParameters.setType(TargetParametersData.TYPE_F_MULTIPLEPOINTS);
        scienceGoal.addTargetParameters(targetParameters);
        TechnicalJustificationModel technicalJustificationModel = new TechnicalJustificationModel(null);
        NonStandardChoicesEditor nonStandardChoicesEditor = new NonStandardChoicesEditor(technicalJustificationModel);
        technicalJustificationModel.setDocument(scienceGoal);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 2));
        jFrame.getContentPane().setPreferredSize(new Dimension(900, 700));
        jFrame.getContentPane().add(nonStandardChoicesEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

