/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplay;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelper;
import alma.obsprep.ot.editors.spatialvisual.mapper.CenterMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.CenterMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.util.GUIUtilities;
import jsky.image.graphics.RoiFigure;

public class MapperManager {
    private CenterMapper centerMapper;
    private PointingMapper pointingMapper;
    private RoiMapper roiMapper;
    private RoiMapper SDRoiMapper;
    private AlmaNavigatorImageDisplay imageDisplay;
    private FieldPattern.FieldPatternType fieldPatternType;
    private DialogId dialogId = new DialogId("SpatialVisualEditor.confirmPatternChange");

    public MapperManager(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel) {
        this.imageDisplay = almaNavigatorImageDisplayPanel.getImageDisplay();
        VisualModelHelper visualModelHelper = almaNavigatorImageDisplayPanel.getModel().getVisualModelHelper();
        CenterMapperModel centerMapperModel = visualModelHelper.getCenterMapperModel();
        PointingMapperModel pointingMapperModel = visualModelHelper.getPointingMapperModel();
        RoiMapperModel roiMapperModel = visualModelHelper.getRoiMapperModel();
        RoiMapperModel roiMapperModel2 = visualModelHelper.getSDRoiMapperModel();
        this.centerMapper = new CenterMapper(almaNavigatorImageDisplayPanel, centerMapperModel);
        this.pointingMapper = new PointingMapper(almaNavigatorImageDisplayPanel, pointingMapperModel);
        this.roiMapper = new RoiMapper(almaNavigatorImageDisplayPanel, roiMapperModel);
        this.SDRoiMapper = new RoiMapper(almaNavigatorImageDisplayPanel, roiMapperModel2){

            @Override
            public boolean isEditable() {
                return false;
            }

            @Override
            protected RoiFigure update() {
                boolean bl;
                RoiFigure roiFigure = super.update();
                try {
                    ScienceGoal scienceGoal = (ScienceGoal)this.getSpatialVisualModel().getSpatialDocument();
                    bl = scienceGoal.getPerformanceParameters().getUseACA();
                }
                catch (Exception exception) {
                    bl = true;
                }
                this.setVisible(bl);
                return roiFigure;
            }
        };
        this.roiMapper.addMapperChangeListener(mapperEvent -> {
            if (this.SDRoiMapper.isActivated()) {
                this.SDRoiMapper.update();
            }
        });
        centerMapperModel.setMapper(this.centerMapper);
        pointingMapperModel.setMapper(this.pointingMapper);
        roiMapperModel.setMapper(this.roiMapper);
        roiMapperModel2.setMapper(this.SDRoiMapper);
        this.imageDisplay.addMouseListener(this.centerMapper);
        this.imageDisplay.addMouseListener(this.pointingMapper);
        this.imageDisplay.addMouseListener(this.roiMapper);
        this.imageDisplay.addMouseMotionListener(this.centerMapper);
        this.imageDisplay.addMouseMotionListener(this.pointingMapper);
        this.imageDisplay.addMouseMotionListener(this.roiMapper);
    }

    public void setFieldSourceCenterCoordinates() {
        this.getCenterMapper().setActivated(true);
        this.clearDrawing();
        this.getCenterMapper().setDrawing(true);
    }

    public void deleteSelectedPattern() {
        this.getPointingMapper().deleteSelectedPattern();
        this.getRoiMapper().deleteSelectedPattern();
    }

    public void addFov() {
        FieldPattern.FieldPatternType fieldPatternType = FieldPattern.FieldPatternType.POINT;
        if (this.confirmFieldPatternChange(fieldPatternType)) {
            if (this.isPatternTypeChanged(fieldPatternType)) {
                this.setFieldPatternType(fieldPatternType);
                this.getPointingMapper().getModel().changeFieldPattern(fieldPatternType);
            }
            this.clearDrawing();
            this.getPointingMapper().setDrawing(true);
        }
    }

    public void addRoiRectangle() {
        FieldPattern.FieldPatternType fieldPatternType = FieldPattern.FieldPatternType.RECTANGLE;
        if (this.confirmFieldPatternChange(fieldPatternType)) {
            if (this.isPatternTypeChanged(fieldPatternType)) {
                this.setFieldPatternType(fieldPatternType);
                this.getRoiMapper().getModel().changeFieldPattern(fieldPatternType);
            }
            this.clearDrawing();
            this.getRoiMapper().setDrawing(true);
            this.getRoiMapper().setRoiMode(3);
        }
    }

    private void clearDrawing() {
        this.getCenterMapper().setDrawing(false);
        this.getPointingMapper().setDrawing(false);
        this.getRoiMapper().setDrawing(false);
    }

    public void setFieldPatternType(FieldPattern.FieldPatternType fieldPatternType) {
        this.fieldPatternType = fieldPatternType;
        if (fieldPatternType != null) {
            if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.POINT)) {
                this.getPointingMapper().setActivated(true);
                this.getRoiMapper().setActivated(false);
                this.getSDRoiMapper().setActivated(false);
            } else if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.RECTANGLE)) {
                this.getPointingMapper().setActivated(false);
                this.getRoiMapper().setActivated(true);
                this.getSDRoiMapper().setActivated(true);
            }
        }
    }

    public FieldPattern.FieldPatternType getFieldPatternType() {
        return this.fieldPatternType;
    }

    private boolean isPatternTypeChanged(FieldPattern.FieldPatternType fieldPatternType) {
        return this.getFieldPatternType() == null || !this.getFieldPatternType().equals((Object)fieldPatternType);
    }

    private boolean confirmFieldPatternChange(FieldPattern.FieldPatternType fieldPatternType) {
        if (this.fieldPatternType == null) {
            return true;
        }
        if (this.isPatternTypeChanged(fieldPatternType)) {
            try {
                ScienceGoal scienceGoal = (ScienceGoal)this.roiMapper.getSpatialVisualModel().getSpatialDocument();
                if (scienceGoal.getTargetParametersCount() > 1) {
                    String string = fieldPatternType.equals((Object)FieldPattern.FieldPatternType.RECTANGLE) ? "Only a single source is permitted if you wish to define a rectangular mapping." : "Only a single source is permitted if you wish to define an individual pointing pattern.";
                    GUIUtilities.warning(this.dialogId, string);
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            boolean bl = GUIUtilities.confirm(this.dialogId, String.format("Do you really want to change field pattern types from %s to %s?", new Object[]{this.fieldPatternType, fieldPatternType}));
            return bl;
        }
        return true;
    }

    public CenterMapper getCenterMapper() {
        return this.centerMapper;
    }

    public PointingMapper getPointingMapper() {
        return this.pointingMapper;
    }

    public RoiMapper getRoiMapper() {
        return this.roiMapper;
    }

    public RoiMapper getSDRoiMapper() {
        return this.SDRoiMapper;
    }
}

